/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.session.ArRpcTimeOut;
import com.bmc.arsys.apitransport.ApiRpcClientStubI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiValueBase;
import com.bmc.arsys.apitransport.arxdrenc.ArApiRpcTcpClient;
import com.bmc.arsys.apitransport.session.ARKeyExchanger;
import com.bmc.arsys.apitransport.session.ARRpcKeyExchangeBase;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.apitransport.session.ArStatusInfo;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.ArGetServerInfo12In;
import com.bmc.arsys.arrpc.ArGetServerInfo12Out;
import com.bmc.arsys.arrpc.arrpc_ARPROG_Client;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.arrpc.xdr.DecoratedArRpcXdrOut;
import com.bmc.arsys.artranscode.ARCharSet;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.XdrAble;
import org.apache.log4j.Logger;

public abstract class ApiRpcClientStubBase
extends arrpc_ARPROG_Client
implements ApiRpcClientStubI {
    private static Logger logger = Logger.getLogger(ApiRpcClientStubBase.class);
    private static String WEBSOCKET_ONMESSAGE = "empty ONC/RPC XDR fragment which is not a trailing fragment";
    private static String WEBSOCKET_ONMESSAGE2 = "can not receive ONC/RPC data";
    private int _svrRpcVersion;

    public ApiRpcClientStubBase(String serverName, int port, int xdrSize, int lowerSvrRpcVersionBy) throws OncRpcException, IOException, AREncryptionException, ARException {
        super(new ArApiRpcTcpClient(new ArRpcCallContext(serverName, port), InetAddress.getByName(serverName), 390620, 0, port, xdrSize));
        this.handShake(serverName, true, lowerSvrRpcVersionBy, xdrSize);
    }

    public ApiRpcClientStubBase(OncRpcClient client) throws OncRpcException, IOException {
        super(client);
    }

    public void handShake(String serverName, boolean initialServerCtxtFlag, int lowerSvrRpcVersionBy, int initXdrSize) throws ARException, IOException, AREncryptionException, OncRpcException {
        ARRpcKeyExchangeBase keyEx = this.createKeyExchanger();
        if (initialServerCtxtFlag) {
            this._svrRpcVersion = this.getClientRpcVersion() - lowerSvrRpcVersionBy;
        }
        boolean keyExchangeSucceed = false;
        boolean keyExchangeRetry = false;
        int haveRetried = 0;
        int maxRetryLimit = 2;
        while ((!keyExchangeSucceed || keyExchangeRetry) && this._svrRpcVersion >= this.getMinimumSupportedServerRpcVersion()) {
            try {
                ARServerContext svrCtx;
                if (keyExchangeRetry) {
                    ++haveRetried;
                }
                keyEx.keyExchangeHandler();
                ((ArApiRpcTcpClient)this.client).setRpcVersion(this._svrRpcVersion);
                keyExchangeSucceed = true;
                if (!initialServerCtxtFlag || (svrCtx = this.initializeServerContext()) == null) continue;
                svrCtx.setCurrentXDRBufferSize(initXdrSize);
                if (this.getArRpcCallContext() instanceof ApiUserContextI) {
                    maxRetryLimit = ((ApiUserContextI)((Object)this.getArRpcCallContext())).getApiConfig().getConnectionMaxRetries();
                }
                this.adjustXdrSizeIfNeeded(svrCtx);
            }
            catch (OncRpcException e) {
                if (e.getReason() == 7) {
                    keyExchangeRetry = true;
                    continue;
                }
                if (ApiRpcClientStubBase.checkForSkipConnection(ApiThreadLocalStorageBlock.getTLB().getApiThreadInfo()) && haveRetried < maxRetryLimit && (WEBSOCKET_ONMESSAGE.equals(e.getLocalizedMessage()) || WEBSOCKET_ONMESSAGE2.equals(e.getLocalizedMessage()))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("keyExchangeRetry w OncRpcExcpetion: " + e.getLocalizedMessage());
                    }
                    keyExchangeRetry = true;
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("About to close the client w OncRpcExcpetion: " + e.getLocalizedMessage());
                }
                this.client.close();
                throw e;
            }
            catch (ARException e) {
                List<StatusInfo> status = e.getLastStatus();
                if (!(status == null || status.size() <= 0 || status.get(0).getMessageNum() != 9002L && status.get(0).getMessageNum() != 9003L && status.get(0).getMessageNum() != 623L || keyExchangeRetry)) {
                    keyExchangeRetry = true;
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("About to close the client w ARException: ", e);
                }
                this.client.close();
                throw e;
            }
        }
        if (!keyExchangeSucceed && !this.isSupportedServerRpcVersion(this._svrRpcVersion)) {
            if (logger.isDebugEnabled()) {
                logger.debug("About to close the client since server rpc version - " + this._svrRpcVersion + " is lower than API getMinimumSupportedServerRpcVersion ");
            }
            this.client.close();
            throw new ARException(2, 8203, serverName);
        }
    }

    private void adjustXdrSizeIfNeeded(ARServerContext svrCtx) throws IOException, OncRpcException {
        int newXdrBufferSize;
        int xdrBufferExtraSpace = 128;
        if (svrCtx.isEncryptionEnabled()) {
            xdrBufferExtraSpace = 4096;
        }
        if ((newXdrBufferSize = Math.max(svrCtx.getRpcClientXDRSizeLimit(), 500000) + xdrBufferExtraSpace) != svrCtx.getCurrentXDRBufferSize()) {
            svrCtx.setCurrentXDRBufferSize(newXdrBufferSize);
            ((ArApiRpcTcpClient)this.client).adjustXdrSize(newXdrBufferSize);
        }
    }

    protected ARServerContext initializeServerContext() throws OncRpcException, ARException {
        ARServerContext serverCtx;
        ArGetServerInfo12In in = new ArGetServerInfo12In();
        ArGetServerInfo12Out out = new ArGetServerInfo12Out();
        in.setControl(new ArControlStruct12());
        ArrayList<Integer> svrInfoTags = new ArrayList<Integer>();
        svrInfoTags.add(2);
        svrInfoTags.add(23);
        svrInfoTags.add(41);
        svrInfoTags.add(55);
        svrInfoTags.add(140);
        svrInfoTags.add(139);
        svrInfoTags.add(4);
        svrInfoTags.add(246);
        svrInfoTags.add(305);
        svrInfoTags.add(286);
        svrInfoTags.add(285);
        int[] ignoredErrs = new int[]{123, 149};
        for (int numReduced = 0; numReduced < svrInfoTags.size(); ++numReduced) {
            int requestSize = svrInfoTags.size() - numReduced;
            in.requestList.value = new int[requestSize];
            for (int i = 0; i < requestSize; ++i) {
                in.requestList.value[i] = (Integer)svrInfoTags.get(i);
            }
            DecoratedArRpcXdrOut dout = new DecoratedArRpcXdrOut(out);
            this.arCall(36, in, dout);
            out = (ArGetServerInfo12Out)dout.getTheObject();
            try {
                ApiRpcClientStubBase.verifyStatus(out);
                break;
            }
            catch (ARException ex) {
                if (ex.canErrorBeIgnored(ignoredErrs)) {
                    continue;
                }
                throw ex;
            }
        }
        if ((serverCtx = this.getArRpcCallContext().getServerContext()) != null) {
            if (out.serverInfoList.value.length > 0 && out.serverInfoList.value[0].operation == 2) {
                serverCtx.setServerLicense(out.serverInfoList.value[0].value.charVal);
            }
            if (out.serverInfoList.value.length > 1 && out.serverInfoList.value[1].operation == 23) {
                serverCtx.setServerId(out.serverInfoList.value[1].value.charVal);
            }
            if (out.serverInfoList.value.length > 2 && out.serverInfoList.value[2].operation == 41) {
                serverCtx.setServerIdent(out.serverInfoList.value[2].value.charVal);
            }
            if (out.serverInfoList.value.length > 3 && out.serverInfoList.value[3].operation == 55) {
                String serverCharSetName = ARCharSet.getServerCharSetName(out.serverInfoList.value[3].value.charVal);
                serverCtx.setServerCharSetName(serverCharSetName);
            }
            if (out.serverInfoList.value.length > 4 && out.serverInfoList.value[4].operation == 140) {
                boolean isServerLocalized = out.serverInfoList.value[4].value.intVal != 0;
                serverCtx.setLocalizedServerFlag(isServerLocalized);
            }
            if (out.serverInfoList.value.length > 5 && out.serverInfoList.value[5].operation == 139) {
                serverCtx.setAlertEventsForm(out.serverInfoList.value[5].value.charVal);
            }
            if (out.serverInfoList.value.length > 6 && out.serverInfoList.value[6].operation == 4) {
                serverCtx.recordServerProductVersion(out.serverInfoList.value[6].value.charVal);
            }
            if (out.serverInfoList.value.length > 7 && out.serverInfoList.value[7].operation == 246) {
                serverCtx.setRpcClientXDRSizeLimit(out.serverInfoList.value[7].value.intVal);
            }
            if (out.serverInfoList.value.length > 8 && out.serverInfoList.value[8].operation == 305) {
                this.getDebugQueues(out.serverInfoList.value[8].value.charVal, serverCtx);
            }
            if (out.serverInfoList.value.length > 9 && out.serverInfoList.value[9].operation == 286) {
                serverCtx.setServerCmtTimeout(out.serverInfoList.value[9].value.intVal);
            }
            if (out.serverInfoList.value.length > 10 && out.serverInfoList.value[10].operation == 285) {
                serverCtx.setServerCmtMax(out.serverInfoList.value[10].value.intVal);
            }
        }
        return serverCtx;
    }

    private void getDebugQueues(String queues, ARServerContext serverCtx) {
        int i = 0;
        int index = 0;
        int[] dbQueues = new int[127];
        for (int j = 0; j < 127; ++j) {
            dbQueues[j] = 0;
        }
        if (queues != null && queues.length() >= 7) {
            String q = queues.substring(index, index + 6);
            while (index < queues.length()) {
                dbQueues[i++] = Integer.parseInt(q);
                index += 7;
            }
        }
        serverCtx.setDbQueues(dbQueues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arCall(int procedureNumber, ArRpcXdrIn params, DecoratedArRpcXdrOut result) throws OncRpcException, ARException {
        try {
            ApiValueBase timeoutValue = new ApiValueBase(this.getTimeOutSetting(procedureNumber));
            this.getArRpcCallContext().setSessionVariable(12, timeoutValue);
            if (this._svrRpcVersion < this.getClientRpcVersion()) {
                XdrAble params2 = this.mapRpcArgument(procedureNumber, params);
                ArRpcXdrOut result2 = this.mapRpcResult(procedureNumber, result);
                this.client.call(procedureNumber, this._svrRpcVersion, params2, result2);
                this.mapRpcResult(procedureNumber, result2, result);
            } else {
                this.client.call(procedureNumber, this._svrRpcVersion, params, result);
            }
        }
        finally {
            this.getArRpcCallContext().cleanRpcCallContext();
        }
    }

    private int getTimeOutSetting(int procedureNumber) {
        int timeOut = 0;
        if (procedureNumber == 182) {
            return 28800;
        }
        switch (ArRpcTimeOut.getInstance().getTimeOut(procedureNumber)) {
            case 2: {
                timeOut = this.getArRpcCallContext().getSessionVariable(3).getIntValue();
                break;
            }
            case 3: {
                timeOut = this.getArRpcCallContext().getSessionVariable(4).getIntValue();
                break;
            }
            default: {
                timeOut = this.getArRpcCallContext().getSessionVariable(2).getIntValue();
            }
        }
        if ((procedureNumber == 34 || procedureNumber == 35) && timeOut < 28800) {
            return 28800;
        }
        return timeOut;
    }

    @Override
    public XdrAble mapRpcArgument(int procNum, XdrAble in) throws OncRpcException {
        return in;
    }

    @Override
    public ArRpcXdrOut mapRpcResult(int procNum, ArRpcXdrOut out) throws OncRpcException {
        return out;
    }

    @Override
    public void mapRpcResult(int procNum, ArRpcXdrOut result, DecoratedArRpcXdrOut out) throws OncRpcException {
        out.setTheObject(result);
    }

    public int getSvrRpcVersion() {
        return this._svrRpcVersion;
    }

    public ArRpcCallContext getArRpcCallContext() {
        return ((ArApiRpcTcpClient)this.getClient()).getArRpcCallContext();
    }

    protected static void verifyStatus(ArRpcXdrOut result) throws ARException {
        if (result == null || result.getStatus() == null) {
            return;
        }
        if (result.getStatus().hasError()) {
            throw new ARException(new ArStatusInfo(result.getStatus()));
        }
    }

    public void enableAPICallEncryption(boolean enable) {
        this.getArRpcCallContext().setEncryptAPICalls(enable);
    }

    private boolean isSupportedServerRpcVersion(int svrRpcVersion) {
        return svrRpcVersion > this.getMinimumSupportedServerRpcVersion();
    }

    protected ARRpcKeyExchangeBase createKeyExchanger() {
        return new ARKeyExchanger(this);
    }

    public static boolean checkForSkipConnection(Map<Object, Object> networkSessionInfo) {
        return OncRpcTcpClient.checkForSkipConnection(networkSessionInfo);
    }
}

