/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiProxyType;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class ApiCMTProxyHolder {
    private static Logger logger = Logger.getLogger(ApiCMTProxyHolder.class);
    private ApiProxyBase proxy;
    private Object parkedSocket;
    private ApiProxyType rpcType;
    private ApiUserContextI context;
    private String proxyJRpcClassName;
    private boolean assigned;

    ApiCMTProxyHolder(ApiUserContextI context, ApiProxyBase proxy, String proxyJRpcClassName, ApiProxyType rpcType) {
        this.proxy = proxy;
        this.rpcType = rpcType;
        this.context = context;
        this.proxyJRpcClassName = proxyJRpcClassName;
    }

    ApiProxyBase getProxy() {
        return this.proxy;
    }

    ApiProxyType getRpcType() {
        return this.rpcType;
    }

    ApiUserContextI getContext() {
        return this.context;
    }

    String getProxyJrpcClassName() {
        return this.proxyJRpcClassName;
    }

    public Object getParkedSocket() {
        return this.parkedSocket;
    }

    void parkSocket(Object sharedSocket) throws ARException {
        if (this.parkedSocket == null && sharedSocket != null) {
            this.parkedSocket = this.proxy.getSocket(this.context);
            if (logger.isDebugEnabled()) {
                logger.debug("CMT park " + this.parkedSocket + " with " + sharedSocket + " for " + this.proxy + "; proxyType=" + this.rpcType);
            }
            this.proxy.setSocket(this.context, sharedSocket);
            if (logger.isDebugEnabled()) {
                logger.debug("CMT verify parked " + this.parkedSocket + " for " + this.proxy + "; proxyType=" + this.rpcType);
            }
        }
    }

    void unparkSocket() throws ARException {
        Object so = this.proxy.getSocket(this.context);
        if (this.parkedSocket != null && !this.parkedSocket.equals(this.proxy.getSocket(this.context))) {
            if (logger.isDebugEnabled()) {
                logger.debug("CMT unpark " + this.parkedSocket + " with currently using " + so + " for " + this.proxy + "; proxyType=" + this.rpcType);
            }
            this.proxy.setSocket(this.context, this.parkedSocket);
        }
        this.parkedSocket = null;
    }

    boolean isAssigned() {
        return this.assigned;
    }

    void setAssigned(boolean assigned) {
        this.assigned = assigned;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiCMTProxyHolder)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ApiCMTProxyHolder rhs = (ApiCMTProxyHolder)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.proxy, rhs.proxy).append(this.rpcType, rhs.rpcType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.proxy).append(this.rpcType).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("proxy", this.proxy).append("rpcType", this.rpcType).toString();
    }
}

