/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.arxdrenc;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordFieldEncryption;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.arrpc.xdr.ArValueStructPswdField;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;

public class ARFieldDataEncyption {
    private final transient PasswordReserveFieldEncryption _pwd123Enc = new PasswordReserveFieldEncryption(false);
    private final transient PasswordFieldEncryption _pwd102Enc = new PasswordFieldEncryption(false);
    private static final transient ARFieldDataEncyption _instance = new ARFieldDataEncyption();

    private ARFieldDataEncyption() {
    }

    public static ARFieldDataEncyption getInstance() {
        return _instance;
    }

    public boolean isEncryptionNeededField(int fieldId) {
        boolean flag = false;
        if (this._pwd102Enc.isEncryptionNeededField(fieldId) || this._pwd123Enc.isEncryptionNeededField(fieldId)) {
            flag = true;
        }
        return flag;
    }

    public ArValueStruct setEncryptedCharValueForPswdFieldToArValueStruct(int fieldId, Object value, int dataType, String serverCharSetName) throws AREncryptionException, UnsupportedEncodingException {
        String errMsg = null;
        if (!(value instanceof String)) {
            errMsg = "value is not a String. Do not call this method. ";
        }
        if (dataType != 4) {
            errMsg = "DataType for field " + fieldId + " has to be AR_DATA_TYPE_CHAR.";
        } else if (!this.isEncryptionNeededField(fieldId)) {
            errMsg = "Field with id " + fieldId + " is not a password field.";
        }
        if (errMsg != null) {
            throw new InvalidParameterException(errMsg);
        }
        ArValueStructPswdField valueStruct = null;
        if (serverCharSetName == null) {
            serverCharSetName = "utf-8";
        }
        if (value == null) {
            value = "";
        }
        byte[] rst = ((String)value).getBytes(serverCharSetName);
        if (this._pwd102Enc.isEncryptionNeededField(fieldId)) {
            if (!this._pwd102Enc.isEncryptedPasswordBytes(rst)) {
                rst = this._pwd102Enc.hashPassword(rst);
            }
        } else if (this._pwd123Enc.isEncryptionNeededField(fieldId)) {
            byte[] decryptedPswd = rst;
            if (this._pwd123Enc.isEncryptedPasswordBytes(rst)) {
                decryptedPswd = this._pwd123Enc.decryptPasswordEx(rst);
            }
            rst = this._pwd123Enc.encryptPasswordEx(decryptedPswd);
        }
        valueStruct = new ArValueStructPswdField(dataType, rst);
        return valueStruct;
    }
}

