/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Value;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StatisticsResultInfo
implements Serializable {
    private static final long serialVersionUID = -7318770796688109058L;
    public static final int AR_STAT_OP_COUNT = 1;
    public static final int AR_STAT_OP_SUM = 2;
    public static final int AR_STAT_OP_AVERAGE = 3;
    public static final int AR_STAT_OP_MINIMUM = 4;
    public static final int AR_STAT_OP_MAXIMUM = 5;
    private List<Value> m_groupByValues;
    private Value m_result;

    public StatisticsResultInfo() {
        this.m_groupByValues = new ArrayList<Value>();
        this.m_result = null;
    }

    public StatisticsResultInfo(List<Value> groupByValues, Value result) {
        this.m_groupByValues = groupByValues;
        this.m_result = result;
    }

    public List<Value> getGroupByValues() {
        return this.m_groupByValues;
    }

    public Value getResult() {
        return this.m_result;
    }

    static List<StatisticsResultInfo> buildGESResponse(Object[] rawData, ARServerUser ctx) {
        ArrayList<StatisticsResultInfo> objList = new ArrayList<StatisticsResultInfo>();
        if (rawData == null) {
            return objList;
        }
        for (Object cur : rawData) {
            if (cur.getClass().isArray()) {
                Object[] varStatRes = (Object[])cur;
                if (varStatRes == null || 2 != varStatRes.length) {
                    objList.add(null);
                    continue;
                }
                Value val = ARTypeMgr.getInstance().ObjectFromVariant(Value.class, varStatRes[1], ctx);
                ArrayList<Value> groupByValues = ARTypeMgr.getInstance().ObjectListFromVariant(Value.class, varStatRes[0], ctx);
                StatisticsResultInfo obj = new StatisticsResultInfo(groupByValues, val);
                objList.add(obj);
                continue;
            }
            objList.add(null);
        }
        return objList;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Group By Values", this.m_groupByValues).append("Result", this.m_result).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_groupByValues).append(this.m_result).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatisticsResultInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StatisticsResultInfo rhs = (StatisticsResultInfo)obj;
        return new EqualsBuilder().append(this.m_groupByValues, rhs.m_groupByValues).append(this.m_result, rhs.m_result).isEquals();
    }
}

