/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SqlCommandProcessor {
    private String sqlCommand;
    private String preparedSqlCommand;

    public SqlCommandProcessor(String sqlCommand) {
        this(sqlCommand, null, null);
    }

    public SqlCommandProcessor(String sqlCommand, Entry keywordList, Entry parameterList) {
        this.sqlCommand = sqlCommand;
        this.preparedSqlCommand = sqlCommand;
        this.substituteFields(keywordList);
        this.substituteFields(parameterList);
    }

    private void substituteFields(Entry entry) {
        if (entry == null || entry.size() <= 0) {
            return;
        }
        String regex = "\\$([^\\$]*)\\$";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(this.preparedSqlCommand);
        boolean doubleQuotesFlag = true;
        int startIndex = 0;
        while (matcher.find(startIndex)) {
            String matchStr = matcher.group(0);
            String enclosedStr = matcher.group(1);
            if (matchStr.compareTo(this.preparedSqlCommand) == 0) {
                doubleQuotesFlag = false;
                break;
            }
            Value val = null;
            if (entry != null) {
                Keyword keyword = Keyword.toKeyword(matchStr);
                int id = keyword != null ? -keyword.toInt() : ConversionUtil.getIntValue(enclosedStr);
                val = (Value)entry.get(id);
            }
            if (val != null) {
                DataType dataType = val.getDataType();
                String valStr = this.getValueAsString(val);
                if (doubleQuotesFlag && (dataType.equals(DataType.CHAR) || dataType.equals(DataType.DIARY))) {
                    valStr = valStr.replaceAll("'", "''");
                }
                this.preparedSqlCommand = this.preparedSqlCommand.replace(matchStr, valStr);
                startIndex = matcher.start() + valStr.length();
                matcher = pattern.matcher(this.preparedSqlCommand);
                continue;
            }
            startIndex = matcher.start() + matchStr.length();
        }
    }

    private String getValueAsString(Value val) {
        if (val == null) {
            return null;
        }
        int dataType = val.getDataType().toInt();
        switch (dataType) {
            case 0: {
                return null;
            }
            case 1: {
                return String.format("$-%d$", val.getKeywordValue());
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return val.toString();
            }
            case 7: {
                return Long.valueOf(val.getTimestampValue()).toString();
            }
            case 13: {
                return Integer.valueOf(val.getDateValue()).toString();
            }
            case 14: {
                return Long.valueOf(val.getTimeValue()).toString();
            }
            case 11: {
                if (val.getValue() instanceof AttachmentValue) {
                    return ((AttachmentValue)val.getValue()).getName();
                }
            }
            case 12: {
                if (!(val.getValue() instanceof CurrencyValue)) break;
                CurrencyValue cur = (CurrencyValue)val.getValue();
                return new String(cur.getValueString() + " " + cur.getCurrencyCode());
            }
        }
        return null;
    }

    public String getPreparedSqlCommand() {
        return this.preparedSqlCommand;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    public static void main(String[] args) {
        String origStr = "'1'=$-1$ AND '2' <= $1$";
        Entry kList = new Entry();
        kList.put(-1, new Value("Some KW Value"));
        Entry pList = new Entry();
        pList.put(1, new Value("Some Char Value"));
        SqlCommandProcessor scp = new SqlCommandProcessor(origStr, kList, pList);
        String prepStr = scp.getPreparedSqlCommand();
        System.out.println(String.format("Prepared SQL Statement for (%s)==> %s", origStr, prepStr));
    }
}

