/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.StatusHistoryItem;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class Converter
extends BaseObject {
    private static final int NUM_CHAR_REORDERINGS = 8;
    private static final int NUM_MAPPINGS_ORDERS = 13;
    private static final int NUM_STRING_COMPLETIONS = 11;
    private static final String[] encryptStringCompletion = new String[]{"*ArtBarryDougGilbertMikeRandy*", "*BarryDougGilbertMikeRandyArt*", "*DougGilbertMikeRandyArtBarry*", "*GilbertMikeRandyArtBarryDoug*", "*MikeRandyArtBarryDougGilbert*", "*RandyArtBarryDougGilbertMike*", "*BethBobDaveDixieMarjorieScott", "*BobDaveDixieMarjorieScottBeth", "*DaveDixieMarjorieScottBethBob", "*DixieMarjorieScottBethBobDave", "*MarjorieScottBethBobDaveDixie"};
    private static final char[][] encryptCharMappings = new char[][]{{'&', 'E', '>', '*', '\u0015', '\u0019', '#', 'Q', '4', '\u001e', '%', '\u001d', '\'', 'L', '\u0004', '\r', '\"', 'A', 'U', '.', '/', '\u000e', '\u0016', ',', '8', 'I', 'K', '!', '0', '\u000f', 'D', 'N', '\u0010', '\u0005', '6', '@', 'S', '\u0013', 'W', 'J', '9', '\u0014', '\u0006', '\u001f', '-', '=', '\u001a', 'G', '^', '(', 'C', 'O', 'H', '\t', ':', 'R', '\u0018', '\n', '?', '\u0017', 'M', 'Z', '\b', ')', '\u0011', '[', 'Y', '\\', 'B', 'P', '<', '\u001b', '5', '7', 'T', ';', '\u0003', '\u0007', '\u000b', ']', '\u0002', 'X', '3', '$', '1', ' ', '\u001c', '\u0001', 'F', '2', '\u0012', '+', '\f', 'V', '\u0000'}, {'9', 'L', 'K', '^', '\f', 'Y', '7', 'D', 'Q', '\u001a', '\t', '*', '\u0010', 'W', '&', '\"', '#', 'G', '\u0006', ':', '>', '\u001b', '\u001d', '\u0016', '\u0002', '6', ';', '\u001f', '\u0007', '\u0019', '\b', ']', '\u0003', '\u000f', '4', '.', '\u001c', ')', '?', '\u000b', '\u0012', '$', '!', '-', 'A', '@', '\u0014', '3', 'P', 'J', '<', 'O', 'N', '\u0018', 'Z', 'X', '\r', '\u0001', 'S', 'H', 'V', '%', '\u001e', '\\', '\'', ' ', '1', '0', '\u0005', '\u0015', 'M', '+', '5', 'I', 'U', '2', '8', 'F', '[', '/', 'T', '(', '\n', 'B', 'C', '\u0004', '\u0017', '\u0013', ',', '=', 'R', '\u0011', 'E', '\u000e', '\u0000'}, {':', '&', 'L', '\u0016', ';', '\u0006', 'B', '\'', 'R', '$', '\t', '[', 'C', '\"', '\n', 'D', 'O', '4', '\u001a', 'Q', '\u001c', '%', '5', '0', 'V', '.', 'U', '\u001b', '\u0012', 'I', '\u000f', '-', 'F', '*', '@', 'T', '\\', '\b', '\u001f', '2', 'A', '#', '7', 'H', '8', '\u0017', 'Z', '\f', ']', 'J', '\u0005', 'G', '\r', '>', '\u0010', ',', '+', '?', '\u0015', '\u001e', '\u0019', 'N', '<', 'W', 'X', 'M', '\u0011', 'K', ' ', '\u0018', '\u000e', '6', '\u0013', 'P', '\u000b', 'S', '\u0007', '\u0001', '\u0004', '=', '1', '(', '\u001d', '\u0003', '^', 'E', '\u0002', '/', '9', '3', 'Y', '!', ')', '\u0014', '\u0000'}, {'>', '!', 'Q', '\u0013', '8', ' ', 'W', 'R', '^', 'H', 'O', '\u000b', '\\', '\u0010', '\u001e', 'P', '\'', '\u0006', '\u0017', '\u000e', '\n', '$', '<', '\u0001', '\u0012', '+', '\u0014', '3', '\u0005', '4', ')', 'T', 'A', ';', '1', 'Z', '\"', '-', ']', '6', 'B', '\u001a', 'I', '\u0019', 'M', 'L', 'G', '\u001d', '#', 'V', '\u001b', '(', '[', '\u0004', 'C', '%', '\r', 'K', '=', '7', '\b', '5', '\u0002', '\u000f', '&', '\f', '9', '\u0007', ',', '@', 'Y', '?', '\u0016', '/', '\u0015', 'D', '\u0018', 'E', '\u0011', '\u001c', 'U', '\u0003', '.', 'X', '\t', '*', '0', '2', 'S', '\u001f', 'J', 'F', 'N', ':', '\u0000'}, {'\u0017', ' ', '/', 'X', '1', '\u001a', 'B', '\u0010', '\u0004', '\u000e', '5', '\u0018', '<', '\u001f', '\u0013', '+', '$', 'L', '\r', 'T', '\u000b', '*', 'W', '0', '!', '[', 'J', 'Z', '\u0006', ':', 'E', 'C', '\n', '\\', '\u001d', '%', '\u000f', '>', '\u001c', '\u001b', 'D', ')', 'H', '\f', 'A', 'P', '\u0007', 'Q', '.', '3', ';', 'N', '^', '6', '7', '\u0005', '(', '\u0011', 'S', '#', '\u0016', '\u0002', '\u001e', '-', 'F', '\u0012', '\b', 'I', 'R', '2', '\"', 'G', '?', '&', 'M', ']', '8', '\u0019', '=', 'K', '\u0001', 'Y', 'O', '\u0015', '\u0003', '@', '\t', '\u0014', '\'', '4', 'U', '9', ',', 'V', '\u0000'}, {']', 'B', 'N', 'O', '3', '\t', ')', '@', '\b', '/', '\u001a', '1', 'C', '!', 'U', '\u0002', '\u0016', 'X', '[', '\u0004', ' ', 'V', ';', '\r', '&', '5', '$', 'J', '\u0012', '\u001b', '*', '\\', '2', 'A', '\u0014', '#', 'T', '(', '.', 'D', '\u000e', '\u0007', 'M', '>', 'E', 'Z', '\u0011', 'P', '\u0006', '8', '\u0019', '\u0005', '\u0003', 'Q', '\u0013', '7', '\u001e', '%', '\u001d', '+', '\u000f', 'G', 'K', '\n', '\u0017', 'F', 'H', '\u001f', '-', '\u000b', '4', 'I', ':', 'L', '\u0018', '\u001c', '?', '=', '^', 'S', '0', '6', '\u0010', '\f', '\'', '\u0015', '\u0001', 'Y', 'W', 'R', '\"', '9', '<', ',', '\u0000'}, {'S', 'W', 'G', 'X', 'H', 'C', '2', '\u001d', '\u0016', '-', 'U', '\u0001', 'Y', '\u0014', '\u0015', 'D', '6', '\u001b', 'E', '0', 'B', '^', '\u001a', '%', '3', '?', 'I', '8', '>', '\u001e', '\u001f', '\u0013', '<', '5', '\u0007', ',', '=', '\u000f', '(', ')', 'A', '\r', '\t', ' ', '#', '\u0004', 'P', '\u0019', 'J', 'T', '\u0012', '\u001c', 'M', '\u0018', 'Z', '4', '!', '*', 'Q', 'K', '7', '\u0005', '\"', '\u0006', '9', ';', 'N', 'R', '\u000b', 'V', '\u0003', '&', ']', '\b', '$', '\u0010', '+', '\n', 'L', '\'', ':', '[', '/', '@', '\f', '\u0017', 'O', '.', '\u000e', '\u0002', '1', 'F', '\u0011', '\\', '\u0000'}};
    private static final int[] encryptCharMappingOrder = new int[]{1, 5, 3, 6, 0, 0, 3, 5, 3, 2, 5, 2, 5, 1, 0, 4, 1, 3, 0, 4, 4, 1, 3, 1, 6, 0, 3, 6, 2, 4, 2, 5, 2, 1, 0, 6, 4, 2, 5, 6, 3, 2, 4};
    private static final int[][] encryptCharReordering = new int[][]{{7, 28, 11, 9, 26, 20, 8, 12, 10, 4, 16, 2, 22, 18, 17, 6, 3, 23, 14, 19, 25, 29, 5, 15, 13, 27, 0, 24, 21, 1}, {16, 25, 12, 17, 26, 24, 14, 18, 21, 7, 2, 3, 5, 19, 10, 13, 0, 9, 23, 27, 20, 8, 22, 6, 15, 29, 11, 4, 1, 28}, {1, 0, 7, 20, 29, 16, 26, 5, 17, 6, 11, 12, 21, 15, 9, 24, 13, 25, 10, 2, 18, 22, 8, 3, 4, 28, 23, 19, 27, 14}, {25, 26, 12, 28, 3, 16, 8, 5, 17, 2, 0, 6, 29, 20, 21, 15, 22, 9, 27, 13, 24, 23, 1, 4, 7, 10, 19, 11, 14, 18}, {9, 13, 27, 0, 16, 25, 22, 11, 14, 5, 7, 19, 20, 8, 21, 15, 17, 18, 10, 12, 24, 29, 2, 1, 26, 23, 3, 4, 28, 6}, {19, 1, 4, 25, 11, 15, 21, 3, 26, 23, 2, 0, 16, 6, 28, 8, 17, 24, 7, 18, 20, 13, 22, 14, 10, 12, 5, 29, 27, 9}, {2, 11, 19, 21, 7, 15, 18, 28, 17, 8, 9, 16, 27, 3, 10, 23, 26, 24, 22, 25, 0, 1, 5, 12, 29, 14, 13, 20, 4, 6}, {12, 1, 2, 11, 26, 19, 4, 28, 17, 18, 7, 25, 21, 29, 3, 23, 0, 6, 8, 27, 5, 20, 14, 10, 13, 16, 9, 24, 15, 22}};
    private static final byte[] arEncryptDecryptFunctionCombination = new byte[]{37, 98, 70, 51, 68, 51, 95, 48, 36, 66, 56, 52, 101, 100, 52, 35, 49, 65, 42, 56, 54, 50, 55, 68, 45, 57, 50, 49, 94, 55, 0};
    private static final int AR_RESERV_PASSWORD = 102;
    private static final int AR_RESERV_ENCRYPTED_STRING = 123;
    private static final int PRE70_AR_MAX_ACCESS_NAME_SIZE = 30;
    private static final int AR_MAX_HASH_SIZE = 28;
    private final ImportOptions options;
    private static final int[] dateStyles = new int[]{3, 2, 1, 0};
    private static final String[] fmtStrings = new String[]{"H:mm:ss", "H:mm", ""};
    private static final char[] dtSepChars = new char[]{'/', '-', '.'};
    private String cachePattern = null;
    private String dateCache = null;
    private String dateTimeCache = null;
    private String timeCache = null;
    private char digitGroupSeparator;
    private char decimalSeparator;
    private String timePattern;
    private String[] amPmSymbols = new String[2];
    private final List<String> dateFormats = Collections.synchronizedList(new ArrayList());
    private final List<String> dateTimeFormats = Collections.synchronizedList(new ArrayList());
    private final List<String> timeFormats = Collections.synchronizedList(new ArrayList());
    public static final String dateTimeFormatter = "MM/dd/yyyy H:mm:ss";
    public static final String dateFormatter = "MM/dd/yyyy G";
    public static final String maxDateTimeValue = "01/18/2038 3:14:07";
    public static final String minDateTimeValue = "01/01/1970 0:00:00";
    public static final String maxDateValue = "01/01/9999 AD";
    public static final String minDateValue = "01/01/4713 BC";
    public static final String singleQuote = "\"";
    public static final String doubleBackwardSlash = "\\\\";
    public static final String singleBackwardSlash = "\\";
    public static final String backwardSlashWithDoubleQuote = "\\\"";
    public static final String dot = ".";
    public static final String underScore = "_";
    public static final String forwardSlash = "/";
    public static final String blank = "";
    public static final char DateSep = '\u0000';
    public static final String currencySepratorForARX = new String(new char[]{'\u0004'});
    public static final String statusHistorySeprator = new String(new char[]{'\u0003'});
    public static final String currencySepratorForRest = new String(new char[]{' '});
    public static final String newLineCharacter = "\n";
    public static final String regexForStripLeading = "^\\s+";
    public static final String regexForStripTrailing = "\\s+$";

    public Converter(ImportOptions options) {
        this.options = options;
        this.setDigitGroupSeparator();
        this.setDecimalSeparator();
        this.setAmPmSymbols();
        this.generateTimePatternFromMappingFile();
        this.populateDateFormats();
        this.populateDateTimeFormats();
        this.populateTimeFormats();
    }

    private void generateTimePatternFromMappingFile() {
        this.timePattern = this.options.getDataOptions().is24Hour() ? "H:mm:ss" : (this.options.getDataOptions().isAMPMSuffix() ? "h:mm:ss a" : "a h:mm:ss");
        if (this.options.getDataOptions().getTimeSeperator() != null && this.options.getDataOptions().getTimeSeperator().length() > 0) {
            this.timePattern = this.timePattern.replaceAll(":", this.options.getDataOptions().getTimeSeperator());
        }
    }

    private void populateDateFormats() {
        if (this.options.getDataOptions().getDateFormat() != null && this.options.getDataOptions().getDateFormat().length() > 0) {
            this.dateFormats.add(this.options.getDataOptions().getDateFormat());
        }
        if (this.options.getDataOptions().getDateTimeFormat() != null && this.options.getDataOptions().getDateTimeFormat().length() > 0) {
            this.dateFormats.add(this.options.getDataOptions().getDateTimeFormat());
        }
        if (this.options.getDataOptions().getCustomDateFormats() != null && this.options.getDataOptions().getCustomDateFormats().size() > 0) {
            for (String format : this.options.getDataOptions().getCustomDateFormats()) {
                this.dateFormats.add(format);
            }
        }
    }

    private void populateDateTimeFormats() {
        StringBuffer temp;
        if (this.options.getDataOptions().getDateFormat() != null && this.options.getDataOptions().getDateFormat().length() > 0) {
            temp = new StringBuffer(this.options.getDataOptions().getDateFormat());
            temp.append(" ");
            temp.append(this.timePattern);
            this.dateTimeFormats.add(temp.toString());
        }
        if (this.options.getDataOptions().getDateTimeFormat() != null && this.options.getDataOptions().getDateTimeFormat().length() > 0) {
            if (this.options.getDataOptions().getDateTimeFormat().contains("h") || this.options.getDataOptions().getDateTimeFormat().contains("H")) {
                this.dateTimeFormats.add(this.options.getDataOptions().getDateTimeFormat());
            } else {
                temp = new StringBuffer(this.options.getDataOptions().getDateTimeFormat());
                temp.append(" ");
                temp.append(this.timePattern);
                this.dateTimeFormats.add(temp.toString());
            }
        }
        if (this.options.getDataOptions().getCustomDateTimeFormats() != null && this.options.getDataOptions().getCustomDateTimeFormats().size() > 0) {
            for (String format : this.options.getDataOptions().getCustomDateTimeFormats()) {
                this.dateTimeFormats.add(format);
            }
        }
    }

    private void populateTimeFormats() {
        this.timeFormats.add(this.timePattern);
        if (this.options.getDataOptions().getCustomTimeFormats() != null && this.options.getDataOptions().getCustomTimeFormats().size() > 0) {
            for (String format : this.options.getDataOptions().getCustomTimeFormats()) {
                this.timeFormats.add(format);
            }
        }
    }

    private static String replaceDateSeparator(String pattern, char separator) {
        StringBuffer result = new StringBuffer(pattern.length());
        if (separator != '\u0000' && pattern.indexOf(separator) == -1) {
            char[] arrPattern = pattern.toCharArray();
            char c = '\u0000';
            for (int i = 0; i < arrPattern.length; ++i) {
                boolean b = false;
                c = arrPattern[i];
                for (char x : dtSepChars) {
                    if (c != x) continue;
                    b = true;
                    if (arrPattern.length <= i + 1 || arrPattern[i + 1] != ' ') break;
                    ++i;
                    break;
                }
                result.append(b ? separator : c);
            }
        } else {
            result = new StringBuffer(pattern);
        }
        return result.toString();
    }

    private Date parseDateTime(String stringRepresentation, int type, Locale locale, boolean lenient, boolean executingFirstTime) {
        char sep;
        Date date = null;
        date = this.parseDateTime(stringRepresentation, type, locale, '\u0000');
        if (date != null) {
            return date;
        }
        char[] arr$ = dtSepChars;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (date = this.parseDateTime(stringRepresentation, type, locale, sep = arr$[i$])) == null; ++i$) {
        }
        if (date == null && executingFirstTime) {
            date = this.parseDateTime(stringRepresentation, 2, Locale.getDefault(), true, false);
        }
        return date;
    }

    private Date parseDateTime(String stringRepresentation, int type, Locale locale, char sepChar) {
        DateFormat dateFormat = null;
        Date date = null;
        boolean success = false;
        switch (type) {
            case 0: {
                for (int i = 0; i < dateStyles.length && !success; ++i) {
                    int dtStyle = dateStyles[i];
                    DateFormat dtFormat = DateFormat.getDateInstance(dtStyle, locale);
                    String datePattern = null;
                    if (dtFormat instanceof SimpleDateFormat) {
                        datePattern = ((SimpleDateFormat)dtFormat).toPattern();
                    }
                    for (int j = 0; j < dateStyles.length + fmtStrings.length && !success; ++j) {
                        ParsePosition parsePosition = new ParsePosition(0);
                        try {
                            if (j < dateStyles.length) {
                                dateFormat = DateFormat.getDateTimeInstance(dtStyle, dateStyles[j], locale);
                                String dateTimePattern = null;
                                if (dateFormat instanceof SimpleDateFormat) {
                                    dateTimePattern = ((SimpleDateFormat)dateFormat).toPattern();
                                }
                                if (dateTimePattern != null) {
                                    dateTimePattern = Converter.replaceDateSeparator(dateTimePattern, sepChar);
                                }
                                ((SimpleDateFormat)dateFormat).applyPattern(dateTimePattern);
                                dateFormat.setLenient(false);
                                date = dateFormat.parse(stringRepresentation, parsePosition);
                                if (parsePosition.getIndex() != stringRepresentation.length()) continue;
                                this.cachePattern = dateTimePattern;
                                success = true;
                                continue;
                            }
                            datePattern = Converter.replaceDateSeparator(datePattern, sepChar);
                            String formatStr = datePattern + " " + fmtStrings[j - dateStyles.length];
                            formatStr = formatStr.trim();
                            SimpleDateFormat sFormat = new SimpleDateFormat(formatStr, locale);
                            sFormat.setLenient(false);
                            date = sFormat.parse(stringRepresentation, parsePosition);
                            if (parsePosition.getIndex() != stringRepresentation.length()) continue;
                            this.cachePattern = formatStr;
                            if (j - dateStyles.length == 2) {
                                this.cachePattern = null;
                            }
                            success = true;
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
            case 1: {
                String patternStr = null;
                for (int i = 0; i < dateStyles.length && !success; ++i) {
                    int dtStyle = dateStyles[i];
                    try {
                        dateFormat = DateFormat.getDateInstance(dtStyle, locale);
                        if (dateFormat instanceof SimpleDateFormat) {
                            patternStr = ((SimpleDateFormat)dateFormat).toPattern();
                        }
                        if (patternStr != null) {
                            patternStr = Converter.replaceDateSeparator(patternStr, sepChar);
                        }
                        ((SimpleDateFormat)dateFormat).applyPattern(patternStr);
                        dateFormat.setLenient(false);
                        date = dateFormat.parse(stringRepresentation);
                        this.cachePattern = patternStr;
                        success = true;
                        DateFormatSymbols dtSymbols = ((SimpleDateFormat)dateFormat).getDateFormatSymbols();
                        String[] eras = dtSymbols.getEras();
                        Calendar cal = Calendar.getInstance(locale);
                        cal.setTime(date);
                        if (stringRepresentation.indexOf(eras[0]) <= -1 || cal.get(0) == 0) continue;
                        cal.set(1, -(cal.get(1) - 1));
                        return cal.getTime();
                    }
                    catch (ParseException e) {
                        ((SimpleDateFormat)dateFormat).applyPattern("G " + patternStr);
                        try {
                            date = dateFormat.parse(stringRepresentation);
                            this.cachePattern = patternStr;
                            success = true;
                            continue;
                        }
                        catch (ParseException e1) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < dateStyles.length && !success; ++i) {
                    int tmStyle = dateStyles[i];
                    dateFormat = DateFormat.getTimeInstance(tmStyle, locale);
                    dateFormat.setLenient(false);
                    ParsePosition pos = new ParsePosition(0);
                    date = dateFormat.parse(stringRepresentation, pos);
                    if (pos.getIndex() != stringRepresentation.length()) continue;
                    this.cachePattern = ((SimpleDateFormat)dateFormat).toPattern();
                    success = true;
                }
                if (success) break;
                for (i = 0; i < fmtStrings.length && !success; ++i) {
                    try {
                        dateFormat = new SimpleDateFormat(fmtStrings[i], locale);
                        ParsePosition parsePosition = new ParsePosition(0);
                        dateFormat.setLenient(false);
                        date = dateFormat.parse(stringRepresentation, parsePosition);
                        if (parsePosition.getIndex() == stringRepresentation.length()) {
                            this.cachePattern = ((SimpleDateFormat)dateFormat).toPattern();
                            success = true;
                            continue;
                        }
                        date = null;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        return date;
    }

    public Value convertDate(FieldInformation fieldInfo, String token, boolean inSeconds) throws ParseException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        if (token != null && token.length() > 0) {
            boolean tryString = false;
            if (inSeconds) {
                try {
                    int intValue = Integer.parseInt(token.trim());
                    result = new Value(new DateInfo(intValue));
                }
                catch (NumberFormatException e) {
                    tryString = true;
                }
            }
            if (!inSeconds || tryString) {
                GregorianCalendar calendar = new GregorianCalendar();
                SimpleDateFormat parser = null;
                Date dateValue = null;
                DateFormatSymbols dtSymbols = new DateFormatSymbols();
                String[] eras = dtSymbols.getEras();
                token = token.replace("B.C.", eras[0]);
                if (this.dateCache != null && this.dateCache.length() > 0) {
                    parser = new SimpleDateFormat(this.dateCache);
                    ParsePosition pos = new ParsePosition(0);
                    pos.setIndex(0);
                    parser.setLenient(false);
                    dateValue = parser.parse(token, pos);
                }
                if (dateValue == null) {
                    for (String format : this.dateFormats) {
                        parser = new SimpleDateFormat(format);
                        ParsePosition pos = new ParsePosition(0);
                        pos.setIndex(0);
                        parser.setLenient(false);
                        dateValue = parser.parse(token, pos);
                        if (dateValue == null || pos.getIndex() != token.length()) continue;
                        this.dateCache = format;
                        break;
                    }
                }
                if (dateValue == null) {
                    dateValue = this.parseDateTime(token, 1, Locale.getDefault(), true, true);
                    this.dateCache = this.cachePattern;
                }
                if (dateValue != null) {
                    if (Locale.getDefault().getCountry().equals("TH")) {
                        calendar.setTime(dateValue);
                        calendar.set(1, calendar.get(1) + 543);
                        if (calendar.get(1) > 2038) {
                            calendar.set(1, calendar.get(1) - 543);
                        }
                        dateValue = calendar.getTime();
                    }
                    calendar.setTime(dateValue);
                    if (token.contains(eras[0]) && calendar.get(0) != 0) {
                        calendar.set(1, -(calendar.get(1) - 1));
                        dateValue = calendar.getTime();
                    }
                    SimpleDateFormat myDateFormat = new SimpleDateFormat(dateFormatter, Locale.US);
                    myDateFormat.setCalendar(new GregorianCalendar());
                    Date before = myDateFormat.parse(maxDateValue);
                    Date after = myDateFormat.parse(minDateValue);
                    if (!(dateValue.after(after) && dateValue.before(before) || dateValue.equals(after) || dateValue.equals(before))) {
                        throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
                    }
                } else {
                    throw new ParseException(ImportErrors.DATE_NOT_PARSED.toDefMsg(), -1);
                }
                calendar.setTime(dateValue);
                int year = calendar.get(1);
                int month = calendar.get(2);
                int day = calendar.get(5);
                if (calendar.get(0) == 0) {
                    year = -(year - 1);
                }
                DateInfo date = new DateInfo(year, month + 1, day);
                result = new Value(date);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_DATE.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertTime(FieldInformation fieldInfo, String token, boolean inSeconds) throws ParseException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        if (token != null && token.length() > 0) {
            boolean tryString = false;
            if (inSeconds) {
                try {
                    long longValue = Long.parseLong(token.trim());
                    result = new Value(new Time(longValue));
                }
                catch (NumberFormatException e) {
                    tryString = true;
                }
            }
            if (!inSeconds || tryString) {
                GregorianCalendar calendar = new GregorianCalendar();
                SimpleDateFormat parser = new SimpleDateFormat();
                Date dateValue = null;
                DateFormatSymbols sym = new DateFormatSymbols();
                sym.setAmPmStrings(this.amPmSymbols);
                parser.setDateFormatSymbols(sym);
                if (this.timeCache != null && this.timeCache.length() > 0) {
                    parser.applyPattern(this.timeCache);
                    ParsePosition pos = new ParsePosition(0);
                    pos.setIndex(0);
                    parser.setLenient(false);
                    dateValue = parser.parse(token, pos);
                }
                if (dateValue == null) {
                    for (String format : this.timeFormats) {
                        parser.applyPattern(format);
                        ParsePosition pos = new ParsePosition(0);
                        pos.setIndex(0);
                        parser.setLenient(false);
                        dateValue = parser.parse(token, pos);
                        if (dateValue == null || pos.getIndex() != token.length()) continue;
                        this.timeCache = format;
                        break;
                    }
                }
                if (dateValue == null) {
                    dateValue = this.parseDateTime(token, 2, Locale.getDefault(), true, true);
                    this.timeCache = this.cachePattern;
                }
                if (dateValue != null) {
                    calendar.setTime(dateValue);
                    int hours = calendar.get(10);
                    int minutes = calendar.get(12);
                    int seconds = calendar.get(13);
                    int isPm = calendar.get(9);
                    if (1 == isPm) {
                        hours += 12;
                    }
                    Time time = new Time((long)(hours * 60 * 60 + minutes * 60 + seconds));
                    result = new Value(time);
                } else {
                    throw new ParseException(ImportErrors.TIME_NOT_PARSED.toDefMsg(), -1);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_TIME.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value convertDateTime(FieldInformation fieldInfo, String token, boolean inSeconds) throws ParseException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        if (token != null && token.length() > 0) {
            boolean tryString = false;
            if (inSeconds) {
                try {
                    long dateVal = Long.parseLong(token.trim());
                    result = new Value(new Timestamp(dateVal));
                }
                catch (NumberFormatException e) {
                    tryString = true;
                }
            }
            if (!inSeconds || tryString) {
                SimpleDateFormat parser = new SimpleDateFormat();
                Date dateValue = null;
                DateFormatSymbols sym = new DateFormatSymbols();
                sym.setAmPmStrings(this.amPmSymbols);
                parser.setDateFormatSymbols(sym);
                if (this.dateTimeCache != null && this.dateTimeCache.length() > 0) {
                    parser.applyPattern(this.dateTimeCache);
                    ParsePosition pos = new ParsePosition(0);
                    pos.setIndex(0);
                    parser.setLenient(false);
                    dateValue = parser.parse(token, pos);
                }
                if (dateValue == null) {
                    for (String format : this.dateTimeFormats) {
                        parser.applyPattern(format);
                        ParsePosition pos = new ParsePosition(0);
                        pos.setIndex(0);
                        parser.setLenient(false);
                        dateValue = parser.parse(token, pos);
                        if (dateValue == null || pos.getIndex() != token.length()) continue;
                        this.dateTimeCache = format;
                        break;
                    }
                }
                if (dateValue == null) {
                    try {
                        Value value = this.convertDate(fieldInfo, token, inSeconds);
                        if (value != null) {
                            return value;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (dateValue == null) {
                    dateValue = this.parseDateTime(token, 0, Locale.getDefault(), true, true);
                    this.dateTimeCache = this.cachePattern;
                }
                if (dateValue == null) throw new ParseException(ImportErrors.DATE_NOT_PARSED.toDefMsg(), -1);
                if (Locale.getDefault().getCountry().equals("TH")) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(dateValue);
                    cal.set(1, cal.get(1) + 543);
                    if (cal.get(1) > 2038) {
                        cal.set(1, cal.get(1) - 543);
                    }
                    dateValue = cal.getTime();
                }
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                SimpleDateFormat myDateFormat = new SimpleDateFormat(dateTimeFormatter, Locale.US);
                myDateFormat.setCalendar(calendar);
                Date before = myDateFormat.parse(maxDateTimeValue);
                Date after = myDateFormat.parse(minDateTimeValue);
                if ((!dateValue.after(after) || !dateValue.before(before)) && !dateValue.equals(after) && !dateValue.equals(before)) throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
                result = new Value(new Timestamp(dateValue));
            }
        }
        if (!logger.isTraceEnabled()) return result;
        logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_DATE_TIME.toDefMsg(), token, result, fieldInfo));
        return result;
    }

    public Value convertString(FieldInformation fieldInfo, String token) throws ARImportException, ARException {
        String password;
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        String substr = blank;
        String serverCharset = this.options.getContext().getServerCharSet();
        if (token.equals(singleQuote)) {
            result = new Value(singleQuote);
            return result;
        }
        if ((fieldInfo.getFieldId() == 102 || fieldInfo.getFieldId() == 123) && (this.options.getFileOptions().getType().equals("ARX") || this.options.getFileOptions().getType().equals("XML") || this.options.getFileOptions().getType().equals("CSV")) && (token = this.unconvertPasswordForARExport(password = token.replace(doubleBackwardSlash, singleBackwardSlash).replace(backwardSlashWithDoubleQuote, singleQuote))) == null) {
            throw new ARImportException(ImportErrors.ERROR_ON_ENCRYPTED_FIELD.toDefMsg());
        }
        try {
            if (this.options.getDataOptions().isTruncate() && fieldInfo.getLimit() != null && fieldInfo.getLimit() instanceof CharacterFieldLimit && ((CharacterFieldLimit)fieldInfo.getLimit()).getMaxLength() > 0) {
                if (((CharacterFieldLimit)fieldInfo.getLimit()).getLengthUnits() == 1 && token.length() > ((CharacterFieldLimit)fieldInfo.getLimit()).getMaxLength()) {
                    substr = token.substring(0, ((CharacterFieldLimit)fieldInfo.getLimit()).getMaxLength());
                } else if (((CharacterFieldLimit)fieldInfo.getLimit()).getLengthUnits() == 0 && token.getBytes(serverCharset).length > ((CharacterFieldLimit)fieldInfo.getLimit()).getMaxLength()) {
                    byte[] tokenBytes = token.getBytes(serverCharset);
                    substr = new String(tokenBytes, 0, ((CharacterFieldLimit)fieldInfo.getLimit()).getMaxLength(), serverCharset);
                    int lastCodePoint = substr.codePointAt(substr.length() - 1);
                    if (lastCodePoint == 65533) {
                        substr = substr.substring(0, substr.length() - 1);
                    }
                } else {
                    substr = token;
                }
            } else {
                substr = token;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ARImportException(ImportErrors.CHARSET_NOT_SUPPORTED.toDefMsg());
        }
        if (substr != null && substr.length() > 0) {
            result = new Value(this.processNewLines(substr, this.options.getDataOptions().getNewLineTokens()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_STRING.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertToARValue(FieldInformation fieldInfo, String token) throws ARImportException, ARException {
        boolean inSeconds;
        Value result = null;
        boolean bl = inSeconds = this.options.getFileOptions().getType().equals("ARX") || this.options.getFileOptions().getType().equals("XML");
        if (token == null) {
            return new Value();
        }
        if (token.startsWith(singleQuote) && token.endsWith(singleQuote) && token.length() == 2) {
            token = blank;
        }
        if (fieldInfo.getFieldId() == 15) {
            result = this.convertStatusHistory(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.CHAR)) {
            result = this.convertString(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.INTEGER)) {
            result = this.convertInteger(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.REAL)) {
            result = this.convertReal(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.DIARY)) {
            result = this.convertDiary(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.ATTACHMENT)) {
            result = this.convertAttachment(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.ENUM)) {
            result = this.convertEnum(fieldInfo, token);
        } else if (fieldInfo.getDataType().equals((Object)DataType.TIME_OF_DAY)) {
            try {
                result = this.convertInteger(fieldInfo, token);
            }
            catch (Exception eParse) {
                try {
                    result = this.convertTime(fieldInfo, token, inSeconds);
                }
                catch (ParseException e) {
                    throw new ARImportException(MessageFormat.format(ImportErrors.INVALID_DATE.toDefMsg(), String.valueOf(fieldInfo.getFieldId()), token));
                }
            }
        } else if (fieldInfo.getDataType().equals((Object)DataType.DATE)) {
            try {
                result = this.convertInteger(fieldInfo, token);
            }
            catch (Exception eParse) {
                try {
                    result = this.convertDate(fieldInfo, token, inSeconds);
                }
                catch (ParseException e) {
                    throw new ARImportException(MessageFormat.format(ImportErrors.INVALID_DATE.toDefMsg(), String.valueOf(fieldInfo.getFieldId()), token));
                }
            }
        } else if (fieldInfo.getDataType().equals((Object)DataType.TIME)) {
            try {
                result = this.convertDateTime(fieldInfo, token, inSeconds);
            }
            catch (ParseException e) {
                if (this.options.getFileOptions().getType().equals("CSV")) {
                    try {
                        result = this.convertDateTime(fieldInfo, token, true);
                    }
                    catch (ParseException e1) {
                        throw new ARImportException(MessageFormat.format(ImportErrors.INVALID_DATE.toDefMsg(), String.valueOf(fieldInfo.getFieldId()), token));
                    }
                }
                throw new ARImportException(MessageFormat.format(ImportErrors.INVALID_DATE.toDefMsg(), String.valueOf(fieldInfo.getFieldId()), token));
            }
        } else if (fieldInfo.getDataType().equals((Object)DataType.DECIMAL)) {
            if (token.length() == 0) {
                result = new Value();
            } else {
                NumberFormat nf = NumberFormat.getInstance();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setGroupingSeparator(this.digitGroupSeparator);
                symbols.setDecimalSeparator(this.decimalSeparator);
                ((DecimalFormat)nf).setDecimalFormatSymbols(symbols);
                ((DecimalFormat)nf).setParseBigDecimal(true);
                this.checkRealNumberFormat(token.trim(), fieldInfo);
                try {
                    Number num = nf.parse(token.trim());
                    token = num.toString();
                }
                catch (ParseException e) {
                    throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
                }
                result = new Value(token, DataType.DECIMAL);
            }
        } else {
            result = fieldInfo.getDataType().equals((Object)DataType.CURRENCY) ? this.convertCurrency(fieldInfo, token) : new Value();
        }
        if (null == result) {
            result = new Value();
        }
        return result;
    }

    public Value convertCurrency(FieldInformation fieldInfo, String token) throws ARImportException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        if (token != null && token.length() > 0) {
            String[] parts = null;
            parts = this.options.getFileOptions().getType().equals("ARX") ? token.split(currencySepratorForARX) : token.split(currencySepratorForRest);
            if (parts == null || parts.length == 0) {
                throw new ARImportException(ImportErrors.CURRENCY_NOT_PARSED.toDefMsg() + token);
            }
            CurrencyValue currency = new CurrencyValue();
            try {
                currency.setValue(new BigDecimal(Double.parseDouble(parts[0].trim())));
            }
            catch (NumberFormatException e) {
                NumberFormat nf = NumberFormat.getInstance();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setGroupingSeparator(this.digitGroupSeparator);
                symbols.setDecimalSeparator(this.decimalSeparator);
                ((DecimalFormat)nf).setDecimalFormatSymbols(symbols);
                this.checkRealNumberFormat(parts[0].trim(), fieldInfo);
                try {
                    Number num = nf.parse(parts[0].trim());
                    symbols.setDecimalSeparator('.');
                    symbols.setGroupingSeparator(',');
                    DecimalFormat formatter = new DecimalFormat("#0.###", symbols);
                    parts[0] = formatter.format(num.doubleValue());
                    currency.setValue(new BigDecimal(Double.parseDouble(parts[0])));
                }
                catch (ParseException pe) {
                    throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + parts[0] + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
                }
            }
            if (parts.length > 1) {
                if (parts[1] != null && parts[1].trim().length() > 3) {
                    throw new ARImportException(ImportErrors.CURRENCY_NOT_PARSED.toDefMsg() + token);
                }
                currency.setCurrencyCode(parts[1]);
            } else {
                currency.setCurrencyCode("USD");
            }
            if (parts.length > 2) {
                currency.setConversionDate(Long.parseLong(parts[2].trim()));
            } else {
                currency.setConversionDate(0L);
            }
            result = new Value(currency);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_CURRENCY.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertAttachment(FieldInformation fieldInfo, String token) throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        if (token != null && token.length() > 0) {
            String path;
            String fullPath;
            File file;
            int idIndex;
            token = token.replace(singleBackwardSlash, System.getProperty("file.separator"));
            String workingToken = token = token.substring(2);
            int extensionDot = workingToken.lastIndexOf(dot);
            String extension = null;
            if (extensionDot > 0) {
                extension = workingToken.substring(extensionDot);
                workingToken = workingToken.substring(0, extensionDot);
            }
            if ((idIndex = workingToken.lastIndexOf(underScore)) > 0) {
                String idToken = workingToken.substring(idIndex + 1);
                boolean onlyDigits = true;
                for (int digitLoop = 0; digitLoop < idToken.toCharArray().length; ++digitLoop) {
                    char currentChar = idToken.toCharArray()[digitLoop];
                    if (Character.isDigit(currentChar)) continue;
                    onlyDigits = false;
                    break;
                }
                if (onlyDigits) {
                    workingToken = workingToken.substring(0, idIndex);
                }
            }
            String name = workingToken.substring(workingToken.lastIndexOf(forwardSlash) + 1);
            if (extension != null) {
                name = name + extension;
            }
            if ((file = new File(fullPath = (path = this.options.getFileOptions().getPath()) + System.getProperty("file.separator") + token)).exists()) {
                AttachmentValue attach = new AttachmentValue();
                attach.setName(name);
                try {
                    attach.setValue(fullPath);
                }
                catch (IOException e) {
                    throw new ARImportException(ImportErrors.CONVERT_ATTACHMENT_FAILED.toDefMsg(), e);
                }
                result = new Value(attach);
            } else {
                logger.error((Object)MessageFormat.format(ImportErrors.ATTACHMENT_MISSING.toDefMsg(), String.valueOf(fieldInfo.getFieldId()), fullPath));
                throw new ARImportException(MessageFormat.format(ImportErrors.ATTACHMENT_MISSING.toDefMsg(), String.valueOf(fieldInfo.getFieldId()), fullPath));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_ATTACHMENT.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertDiary(FieldInformation fieldInfo, String token) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (fieldInfo.getFieldId() == 15) {
            return this.convertStatusHistory(fieldInfo, token);
        }
        List<String> newLineTokens = this.options.getDataOptions().getNewLineTokens();
        if (newLineTokens != null && newLineTokens.size() > 0) {
            for (String newLine : newLineTokens) {
                token = token.replace(newLine, newLineCharacter);
            }
        }
        Value result = new Value();
        if (token != null && token.length() > 0) {
            try {
                result = new Value(DiaryListValue.decode((String)token));
            }
            catch (ARException e) {
                if (((StatusInfo)e.getLastStatus().get(0)).getMessageNum() == 339L) {
                    DiaryListValue diaryValue = new DiaryListValue();
                    diaryValue.add((Object)new DiaryItem(this.options.getContext().getUser(), token, new Timestamp(new Date())));
                    result = new Value(diaryValue);
                }
                throw e;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_DIARY.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertReal(FieldInformation fieldInfo, String token) throws ARException, ARImportException {
        Value result = new Value();
        Logger logger = ThreadLocalStorage.getLogger();
        if (token != null && token.length() > 0) {
            NumberFormat nf = NumberFormat.getInstance();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setGroupingSeparator(this.digitGroupSeparator);
            symbols.setDecimalSeparator(this.decimalSeparator);
            ((DecimalFormat)nf).setDecimalFormatSymbols(symbols);
            ((DecimalFormat)nf).getMinimumFractionDigits();
            this.checkRealNumberFormat(token.trim(), fieldInfo);
            try {
                Number num = nf.parse(token.trim());
                token = num.toString();
            }
            catch (ParseException e) {
                throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
            }
            result = new Value(Double.parseDouble(token.trim()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_REAL.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertInteger(FieldInformation fieldInfo, String token) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        try {
            if (token != null && token.length() > 0) {
                result = new Value(Integer.parseInt(token.trim()));
            }
        }
        catch (NumberFormatException e) {
            throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_INTEGER.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    public Value convertEnum(FieldInformation fieldInfo, String token) throws IllegalArgumentException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = null;
        if (token != null && token.length() > 0) {
            try {
                long longValue = Long.parseLong(token.trim());
                result = new Value((Object)longValue, DataType.ENUM);
            }
            catch (NumberFormatException e) {
                long retVal = fieldInfo.getEnumValue(token);
                if (-1L == retVal) {
                    throw new ARException(Arrays.asList(new StatusInfo(2, 306L, ImportErrors.VALUE_NOT_FALL_IN_LIMIT.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
                }
                result = new Value((Object)retVal, DataType.ENUM);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_ENUM.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    protected String processNewLines(String token, List<String> newLineTokens) {
        if (newLineTokens != null && newLineTokens.size() > 0) {
            for (String newLine : newLineTokens) {
                token = token.replace(newLine, newLineCharacter);
            }
        }
        if (this.options.getFileOptions().getType().equals("ARX") || this.options.getFileOptions().getType().equals("XML")) {
            token = token.replace("\\\n", "\\n");
            token = token.replace(doubleBackwardSlash, singleBackwardSlash);
        }
        if (this.options.getDataOptions().isStripLeading() && this.options.getDataOptions().isStripTrailing()) {
            token = token.trim();
        } else if (this.options.getDataOptions().isStripLeading()) {
            token = token.replaceAll(regexForStripLeading, blank);
        } else if (this.options.getDataOptions().isStripTrailing()) {
            token = token.replaceAll(regexForStripTrailing, blank);
        }
        return token;
    }

    public Value getKeywordValue(FieldInformation fieldInfo, Mapping mapping) {
        if (mapping.getKeyword() instanceof Integer) {
            return new Value();
        }
        if (mapping.getKeyword() instanceof Keyword) {
            return new Value((Keyword)mapping.getKeyword());
        }
        return new Value();
    }

    public Value convertStatusHistory(FieldInformation fieldInfo, String token) throws ARImportException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        Value result = new Value();
        NumberFormat nf = NumberFormat.getInstance();
        if (fieldInfo.getFieldId() == 15 && token != null && token.length() > 0) {
            String[] lines;
            StatusHistoryValue statusHistory = new StatusHistoryValue();
            for (String line : lines = token.split(statusHistorySeprator)) {
                if (line.length() == 0) {
                    statusHistory.add(null);
                    continue;
                }
                String[] parts = line.split(currencySepratorForARX);
                if (parts.length == 2) {
                    String user = parts[1];
                    if (user == null || user.length() == 0) {
                        user = blank;
                    }
                    try {
                        String number = parts[0].trim();
                        if (number.length() > 0) {
                            Number num = nf.parse(number);
                            statusHistory.add((Object)new StatusHistoryItem(user, new Timestamp(num.longValue())));
                            continue;
                        }
                        statusHistory.add(null);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ARException(2, 340, token);
                    }
                }
                if (parts.length == 1) {
                    if (parts[0].length() == 0) {
                        statusHistory.add(null);
                        continue;
                    }
                    try {
                        Number num = nf.parse(parts[0].trim());
                        statusHistory.add((Object)new StatusHistoryItem(blank, new Timestamp(num.longValue())));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ARException(2, 340, token);
                    }
                }
                if (parts.length != 0) continue;
                statusHistory.add(null);
            }
            result = statusHistory.size() > 0 ? new Value((Object)statusHistory, DataType.DIARY) : new Value();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format(ImportErrors.CONVERT_STATUS_HISTORY.toDefMsg(), token, result, fieldInfo));
        }
        return result;
    }

    private String unconvertPasswordForARExport(String token) throws ARImportException {
        String result = token;
        if (result.length() > 120) {
            result = result.substring(0, 120);
        }
        if (result.length() == 120) {
            PasswordEncryption encryptor = new PasswordEncryption(3, false);
            try {
                byte[] bytes = encryptor.decryptPasswordEx(token.getBytes());
                result = new String(bytes);
            }
            catch (AREncryptionException e) {
                throw new ARImportException(ImportErrors.UNKNOWN_ERROR.toDefMsg());
            }
        } else if (result.length() >= 30) {
            int seed = Integer.parseInt(result.substring(30).trim());
            result = this.decryptPassword(seed, result);
        } else if (result.length() == 28) {
            // empty if block
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String decryptPassword(int seed, String password) {
        String completionEnd;
        int j;
        int i;
        if (password == null || password.length() <= 0) return password;
        StringBuffer decryptBuffer = new StringBuffer(password);
        StringBuffer passwordBuffer = new StringBuffer(password);
        int tempInt = seed % 8;
        block0: for (i = 0; i < 30; ++i) {
            for (j = 0; j < 30; ++j) {
                if (encryptCharReordering[tempInt][j] != i) continue;
                passwordBuffer.setCharAt(i, decryptBuffer.charAt(j));
                continue block0;
            }
        }
        tempInt = seed % 95;
        int tempInt2 = seed % 13;
        block2: for (i = 0; i < 30; ++i) {
            int tempInt4;
            if (passwordBuffer.charAt(i) >= ' ' && passwordBuffer.charAt(i) <= '~') {
                tempInt4 = 32;
            } else {
                if (passwordBuffer.charAt(i) < '\u00a0' || passwordBuffer.charAt(i) > '\u00fe') continue;
                tempInt4 = 160;
            }
            passwordBuffer.setCharAt(i, (char)(passwordBuffer.charAt(i) - tempInt4));
            int tempInt3 = tempInt;
            for (j = 0; j < 95; ++j) {
                if (encryptCharMappings[encryptCharMappingOrder[tempInt2 + i]][tempInt3] == passwordBuffer.charAt(i)) {
                    if ((tempInt3 = tempInt3 - tempInt + tempInt4) < tempInt4) {
                        tempInt3 += 95;
                    }
                    passwordBuffer.setCharAt(i, (char)tempInt3);
                    continue block2;
                }
                if (tempInt3 >= 94) {
                    tempInt3 = 0;
                    continue;
                }
                ++tempInt3;
            }
        }
        tempInt = seed % 11;
        int completionPosition = passwordBuffer.toString().lastIndexOf(encryptStringCompletion[tempInt].charAt(0));
        if (completionPosition <= 0) return passwordBuffer.toString();
        String passwordEnd = passwordBuffer.substring(completionPosition, 30);
        if (!passwordEnd.equals(completionEnd = encryptStringCompletion[tempInt].substring(0, 30 - completionPosition))) return null;
        return passwordBuffer.substring(0, completionPosition);
    }

    public void setDigitGroupSeparator() {
        if (this.options.getDataOptions().getDigitGroupSeparator() != null && this.options.getDataOptions().getDigitGroupSeparator().length() > 0) {
            this.digitGroupSeparator = this.options.getDataOptions().getDigitGroupSeparator().equalsIgnoreCase("nbsp") ? (char)160 : this.options.getDataOptions().getDigitGroupSeparator().charAt(0);
        } else if (this.options.getDataOptions().getCustomDigitgroupSeparator() != null && this.options.getDataOptions().getCustomDigitgroupSeparator().length() > 0) {
            this.digitGroupSeparator = this.options.getDataOptions().getCustomDigitgroupSeparator().equalsIgnoreCase("nbsp") ? (char)160 : this.options.getDataOptions().getCustomDigitgroupSeparator().charAt(0);
        } else {
            DecimalFormatSymbols sym = this.options.getFileOptions().getType().equals("ARX") ? new DecimalFormatSymbols(Locale.US) : new DecimalFormatSymbols();
            this.digitGroupSeparator = sym.getGroupingSeparator();
        }
    }

    public void setDecimalSeparator() {
        if (this.options.getDataOptions().getDecimalSeparator() != null && this.options.getDataOptions().getDecimalSeparator().length() > 0) {
            this.decimalSeparator = this.options.getDataOptions().getDecimalSeparator().equalsIgnoreCase("nbsp") ? (char)160 : this.options.getDataOptions().getDecimalSeparator().charAt(0);
        } else if (this.options.getDataOptions().getCustomDecimalSeparator() != null && this.options.getDataOptions().getCustomDecimalSeparator().length() > 0) {
            this.decimalSeparator = this.options.getDataOptions().getCustomDecimalSeparator().equalsIgnoreCase("nbsp") ? (char)160 : this.options.getDataOptions().getCustomDecimalSeparator().charAt(0);
        } else {
            DecimalFormatSymbols sym = this.options.getFileOptions().getType().equals("ARX") ? new DecimalFormatSymbols(Locale.US) : new DecimalFormatSymbols();
            this.decimalSeparator = sym.getDecimalSeparator();
        }
    }

    public void setAmPmSymbols() {
        DateFormatSymbols sym = new DateFormatSymbols();
        String[] amPmStrings = sym.getAmPmStrings();
        this.amPmSymbols[0] = this.options.getDataOptions().getAMString() != null && this.options.getDataOptions().getAMString().length() > 0 ? this.options.getDataOptions().getAMString() : (this.options.getDataOptions().getCustomAMString() != null && this.options.getDataOptions().getCustomAMString().length() > 0 ? this.options.getDataOptions().getCustomAMString() : amPmStrings[0]);
        this.amPmSymbols[1] = this.options.getDataOptions().getPMString() != null && this.options.getDataOptions().getPMString().length() > 0 ? this.options.getDataOptions().getPMString() : (this.options.getDataOptions().getCustomPMString() != null && this.options.getDataOptions().getCustomPMString().length() > 0 ? this.options.getDataOptions().getCustomPMString() : amPmStrings[1]);
    }

    private void checkRealNumberFormat(String token, FieldInformation fieldInfo) throws ARException {
        int groupSeparatorIndex = token.lastIndexOf(this.digitGroupSeparator);
        int decimalSeparatorIndex = token.lastIndexOf(this.decimalSeparator);
        int decimalSeparatorCount = 0;
        int invalidCharFlag = 0;
        for (int i = 0; i < token.length(); ++i) {
            char d = token.charAt(i);
            if (d == this.decimalSeparator) {
                ++decimalSeparatorCount;
            }
            if (i == 0 && d == '-' || Character.isDigit(d) || d == this.decimalSeparator || d == this.digitGroupSeparator) continue;
            ++invalidCharFlag;
        }
        if (decimalSeparatorCount > 1 || invalidCharFlag > 0) {
            throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
        }
        if (groupSeparatorIndex >= 0 && token.charAt(0) == this.digitGroupSeparator) {
            throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
        }
        if (decimalSeparatorIndex >= 0 && groupSeparatorIndex >= 0 && groupSeparatorIndex > decimalSeparatorIndex) {
            throw new ARException(Arrays.asList(new StatusInfo(2, 4206L, '\"' + token + '\"' + ImportErrors.INVALID_VALUE.toDefMsg() + String.valueOf(fieldInfo.getFieldId()), null)));
        }
    }
}

