/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.ArNetworkSocketHelper;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Object socket;
    private ArNetworkSocket socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;
    private static final String WEBSOCKET_URL_KEY = "webSocket.URL";

    public OncRpcTcpClient(InetAddress host, int program, int version) throws OncRpcException, IOException {
        this(host, program, version, 0, 0);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        this(host, program, version, port, 0);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        this(host, program, version, port, bufferSize, -1);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize, int timeout) throws OncRpcException, IOException {
        super(host, program, version, port, 6);
        if (bufferSize == 0) {
            bufferSize = 8192;
        }
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.createNetworkSocket(host, bufferSize, timeout, null);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        this(host, program, version, port, bufferSize, -1, networkSessionInfo);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize, int timeout, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(host, program, version, !OncRpcTcpClient.checkForSkipConnection(networkSessionInfo) ? port : -1, 6);
        if (bufferSize == 0) {
            bufferSize = 8192;
        }
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if (this.port == -1) {
            this.port = port;
        }
        this.createNetworkSocket(host, bufferSize, timeout, networkSessionInfo);
    }

    protected void createNetworkSocket(InetAddress host, int bufferSize, int timeout, Map<Object, Object> networkSessionInfo) throws IOException {
        this.socketHelper = this.createNewtowrkSocketHelper(host, this.port, timeout, networkSessionInfo);
        this.socketHelper.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.sendingXdr = this.aNewXdrTcpEncodingStream(null, this.socketHelper, bufferSize);
        this.receivingXdr = this.aNewXdrTcpDecodingStream(null, this.socketHelper, bufferSize);
    }

    @Override
    public void close() throws OncRpcException {
        this.closeSocket();
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    @Override
    public synchronized void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        for (int refreshesLeft = 1; refreshesLeft >= 0; --refreshesLeft) {
            String msg;
            this.nextXid();
            OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, versionNumber, procedureNumber, this.auth);
            OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
            try {
                if (debugout != null) {
                    msg = "call: ProcNumber=" + procedureNumber + " Sending...." + " msgId=" + this.xid;
                    msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                    debugout.println(msg);
                }
                this.setSoTimeout(this.transmissionTimeout);
                this.beginEncoding(procedureNumber, null, 0);
                callHeader.xdrEncode(this.sendingXdr);
                this.encodeParams(params);
                if (this.timeout != 0) {
                    this.sendingXdr.endEncoding();
                } else {
                    this.sendingXdr.endEncoding(false);
                }
            }
            catch (IOException e) {
                throw new OncRpcException(3, e.getLocalizedMessage());
            }
            finally {
                try {
                    this.endEncoding(procedureNumber);
                }
                catch (IOException e) {
                    throw new OncRpcException(3, e.getLocalizedMessage());
                }
            }
            if (this.timeout == 0) {
                return;
            }
            try {
                if (debugout != null) {
                    msg = "call: ProcNumber=" + procedureNumber + " Receiving....";
                    msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                    debugout.println(msg);
                }
                while (true) {
                    this.setSoTimeout(this.timeout);
                    this.beginDecoding(procedureNumber);
                    this.setSoTimeout(this.transmissionTimeout);
                    try {
                        replyHeader.xdrDecode(this.receivingXdr);
                    }
                    catch (OncRpcException e) {
                        this.receivingXdr.endDecoding();
                        throw e;
                    }
                    if (debugout != null) {
                        msg = "call: ProcNumber=" + procedureNumber + " Received msgId=" + replyHeader.messageId;
                        msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                        debugout.println(msg);
                    }
                    if (replyHeader.messageId == callHeader.messageId) break;
                    if (debugout != null) {
                        msg = "call: ProcNumber=" + procedureNumber + " mismatched msgId. try again!";
                        msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                        debugout.println(msg);
                    }
                    this.receivingXdr.endDecoding();
                }
                if (!replyHeader.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (refreshesLeft > 0 && replyHeader.replyStatus == 1 && replyHeader.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue;
                    throw replyHeader.newException();
                }
                try {
                    this.decodeResult(result);
                }
                catch (OncRpcException e) {
                    this.receivingXdr.endDecoding();
                    throw e;
                }
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException e) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException e) {
                throw new OncRpcException(4, e.getLocalizedMessage());
            }
            finally {
                try {
                    this.endDecoding(procedureNumber);
                }
                catch (IOException e) {
                    throw new OncRpcException(4, e.getLocalizedMessage());
                }
            }
        }
    }

    public synchronized void batchCall(int procedureNumber, XdrAble params, boolean flush) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, this.version, procedureNumber, this.auth);
        try {
            this.setSoTimeout(this.transmissionTimeout);
            this.beginEncoding(procedureNumber, null, 0);
            callHeader.xdrEncode(this.sendingXdr);
            params.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(flush);
        }
        catch (IOException e) {
            throw new OncRpcException(3, e.getLocalizedMessage());
        }
        finally {
            try {
                this.endEncoding(procedureNumber);
            }
            catch (IOException e) {
                throw new OncRpcException(3, e.getLocalizedMessage());
            }
        }
    }

    public void setSoTimeout(int timeout) throws IOException {
        ((Socket)this.socket).setSoTimeout(timeout);
    }

    @Override
    public void setTimeout(int milliseconds) {
        super.setTimeout(milliseconds);
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.receivingXdr.setCharacterEncoding(characterEncoding);
        this.sendingXdr.setCharacterEncoding(characterEncoding);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public Object getSocket() {
        return this.socket;
    }

    public void setSocket(Object so) {
        this.socket = so;
    }

    public void encodeParams(XdrAble params) throws OncRpcException, IOException {
        params.xdrEncode(this.sendingXdr);
    }

    public void decodeResult(XdrAble result) throws OncRpcException, IOException {
        result.xdrDecode(this.receivingXdr);
    }

    public ArNetworkSocket getSocketHelper() {
        return this.socketHelper;
    }

    protected void beginDecoding(int procedureNumber) throws IOException, OncRpcException {
        this.receivingXdr.beginDecoding();
    }

    protected void endDecoding(int procedureNumber) throws IOException, OncRpcException {
    }

    protected void beginEncoding(int procedureNumber, InetAddress receiverAddress, int receiverPort) throws IOException, OncRpcException {
        this.sendingXdr.beginEncoding(receiverAddress, receiverPort);
    }

    protected void endEncoding(int procedureNumber) throws IOException, OncRpcException {
    }

    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object obj, ArNetworkSocket socketWrapper, int senderLen) throws IOException {
        this.sendingXdr = new XdrTcpEncodingStream(socketWrapper, senderLen);
        return this.sendingXdr;
    }

    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object obj, ArNetworkSocket socketWrapper, int senderLen) throws IOException {
        this.receivingXdr = new XdrTcpDecodingStream(socketWrapper, senderLen);
        return this.receivingXdr;
    }

    protected ArNetworkSocket createNewtowrkSocketHelper(InetAddress host, int port, int timeout, Map<Object, Object> sessionInfo) throws IOException {
        this.socketHelper = new ArNetworkSocketHelper(host, port, timeout, sessionInfo);
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client will connect to " + host + ":" + this.port);
        }
        this.socketHelper.connect();
        this.socket = this.socketHelper.getSocket();
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client bound to " + this.socket);
            if (this.socket instanceof Socket) {
                System.out.println("with localInetAddress: " + ((Socket)this.socket).getLocalSocketAddress() + "; remoteInetAddress: " + ((Socket)this.socket).getRemoteSocketAddress());
            } else if (this.socket instanceof SocketChannel) {
                System.out.println("with localInetAddress: " + ((SocketChannel)this.socket).socket().getLocalSocketAddress() + "; remoteInetAddress: " + ((SocketChannel)this.socket).socket().getRemoteSocketAddress());
            }
        }
        return this.socketHelper;
    }

    public static boolean checkForSkipConnection(Map<Object, Object> networkSessionInfo) {
        boolean flag = false;
        flag = networkSessionInfo != null && networkSessionInfo.size() != 0 && networkSessionInfo.get(WEBSOCKET_URL_KEY) != null && ((String)networkSessionInfo.get(WEBSOCKET_URL_KEY)).length() != 0;
        return flag;
    }

    protected void closeSocket() {
        if (this.socket != null) {
            try {
                ((Socket)this.socket).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

