/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindInet6;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrString;

public class ArRpcBindHelper {
    public static final int IPV6_BIT = 1;
    public static final int IPV4_BIT = 2;
    public static final String serverName_IPv4 = "127.0.0.1";
    public static final String serverName_IPv6 = "::1";
    public static final String serverName_LOCALHOST = "localhost";
    public static String tcp6_netid;
    public static String udp6_netid;
    public static String owner;
    public static boolean serverName_LOCALHOST_SERVER;
    public static final int SERVER_TCP_MIN_VER = 1;
    public static final int SERVER_TCP6_MIN_VER = 20;
    public static final int PLUGINSVR_TCP_MIN_VER = 1;
    public static final int PLUGINSVR_TCP6_MIN_VER = 4;
    public static Boolean rpcbind_client_debug;
    public static final int PMAP_VERSION = 4;
    public static int server_min_api_ver;

    static XdrAble getRpcBindRequestParams(InetAddress host, int procedureNumber, int program, int version, int protocol, int port) {
        if (host instanceof Inet6Address) {
            return new ArRpcBindInet6(host, program, version, protocol, port);
        }
        if (serverName_LOCALHOST_SERVER) {
            return new ArRpcBindInet6(host, program, version, protocol, port);
        }
        return new OncRpcServerIdent(program, version, protocol, port);
    }

    static XdrAble getRpcBindResponseParams(InetAddress host, int procedureNumber, boolean flag) {
        if (procedureNumber == 3) {
            if (host instanceof Inet6Address) {
                return new XdrString();
            }
            if (serverName_LOCALHOST_SERVER) {
                return new XdrString();
            }
            return new OncRpcGetPortResult();
        }
        return new XdrBoolean(flag);
    }

    static int getPort(String rtnStr) {
        String[] rtnSeg;
        int port = 0;
        if (rtnStr != null && rtnStr.length() > 0 && (rtnSeg = rtnStr.split("\\.")).length > 2) {
            try {
                int h = Integer.parseInt(rtnSeg[rtnSeg.length - 2]) << 8;
                int l = Integer.parseInt(rtnSeg[rtnSeg.length - 1]);
                port = h + l;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return port;
    }

    public static int getRpcBindTryStopVersion(int version) {
        int stopVersion = version;
        if (version == 4) {
            --stopVersion;
        }
        return stopVersion;
    }

    public static int getServerMinVersionToRegisger(InetAddress host) {
        if (host instanceof Inet6Address) {
            return 20;
        }
        if (server_min_api_ver > 0) {
            return server_min_api_ver;
        }
        return 1;
    }

    public static int getPluginSvrMinVersionToRegisger(InetAddress host) {
        if (host instanceof Inet6Address) {
            return 4;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String netId;
        tcp6_netid = "tcp6";
        udp6_netid = "upd6";
        owner = "bmc";
        serverName_LOCALHOST_SERVER = false;
        rpcbind_client_debug = false;
        server_min_api_ver = -1;
        try {
            String verbose = System.getProperty("rpcbind_client_debug");
            if (verbose != null && verbose.length() > 0 && (rpcbind_client_debug = Boolean.valueOf("true".equalsIgnoreCase(verbose))).booleanValue()) {
                System.out.println("system property : rpcbind_client_debug = " + rpcbind_client_debug);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            String minApiVer = System.getProperty("server_min_api_ver");
            if (minApiVer != null && minApiVer.length() > 0) {
                server_min_api_ver = Integer.valueOf(minApiVer);
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : server_min_api_ver = " + server_min_api_ver);
                }
            }
        }
        catch (Throwable e) {
        }
        finally {
            if (server_min_api_ver == -1) {
                server_min_api_ver = 0;
            }
        }
        try {
            netId = System.getProperty("tcp6_netid");
            if (netId != null && netId.length() > 0) {
                tcp6_netid = netId;
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : rpc6_netid = " + tcp6_netid);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            netId = System.getProperty("udp6_netid");
            if (netId != null && netId.length() > 0) {
                udp6_netid = netId;
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : udp6_netid = " + udp6_netid);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            String owner = System.getProperty("owner");
            if (owner != null && owner.length() > 0) {
                ArRpcBindHelper.owner = owner;
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : owner = " + ArRpcBindHelper.owner);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

