/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;

public class ArLogBytes {
    private static PrintWriter debugout = null;
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static boolean socket_bytelog_debug = false;
    private static boolean _DEBUG_ON = false;
    private static boolean _lineBreak = false;
    private static String byteLogFileName;

    private ArLogBytes() {
    }

    public static String getByteLogFileName() {
        return byteLogFileName;
    }

    public static boolean isDebugEnabled() {
        return socket_bytelog_debug || _DEBUG_ON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDebugOn(boolean flag) {
        _DEBUG_ON = flag;
        if (flag) {
            System.out.println(byteLogFileName);
            if (debugout == null) {
                String string = byteLogFileName;
                synchronized (string) {
                    if (debugout == null) {
                        try {
                            debugout = new PrintWriter(new FileOutputStream(byteLogFileName, true), true);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public static void debugout(String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        String msgout = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
        debugout.println(msgout);
        System.out.println(msgout);
    }

    public static void printByteArrayAsHex(byte[] in, String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        if (in == null || in.length == 0) {
            ArLogBytes.debugout("Byte array is null!");
        } else {
            ArLogBytes.debugout(msg);
            ArLogBytes.debugout("Byte array as hex values : len = " + in.length);
            StringBuilder hex = new StringBuilder();
            for (int i = 0; i < in.length; ++i) {
                if (_lineBreak && i % 16 == 0 && i != 0) {
                    ArLogBytes.debugout(hex.toString());
                    hex = new StringBuilder();
                }
                int h = in[i] & 0xFF;
                String hStr = Integer.toHexString(h);
                if (Integer.toHexString(h).length() == 1) {
                    hex.append("0").append(hStr).append(" ");
                    continue;
                }
                hex.append(hStr).append(" ");
            }
            ArLogBytes.debugout(hex.toString());
        }
    }

    public static void printByteArrayAsHex(byte[] in, int start, int bytesToRead, String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        int len = start + bytesToRead;
        if (in == null || in.length == 0 || bytesToRead <= 0 || in.length < bytesToRead) {
            ArLogBytes.debugout("Did not indicate how many bytes to log from buffer: " + in.length);
        } else {
            ArLogBytes.debugout(msg);
            StringBuilder hex = new StringBuilder();
            for (int i = start; i < len; ++i) {
                if (_lineBreak && i % 16 == 0 && i != 0) {
                    ArLogBytes.debugout(hex.toString());
                    hex = new StringBuilder();
                }
                int h = in[i] & 0xFF;
                String hStr = Integer.toHexString(h);
                if (Integer.toHexString(h).length() == 1) {
                    hex.append("0").append(hStr).append(" ");
                    continue;
                }
                hex.append(hStr).append(" ");
            }
            ArLogBytes.debugout(hex.toString());
        }
    }

    public static void printByteArrayAsHexArray(byte[] in, String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        if (in == null || in.length == 0) {
            ArLogBytes.debugout("Byte array is null!");
        } else {
            ArLogBytes.debugout(msg);
            ArLogBytes.debugout("Byte array as hex values : len = " + in.length);
            StringBuilder hex = new StringBuilder();
            hex.append("{");
            for (int i = 0; i < in.length; ++i) {
                if (_lineBreak && i % 8 == 0 && i != 0) {
                    ArLogBytes.debugout(hex.toString());
                    hex = new StringBuilder();
                }
                int h = in[i] & 0xFF;
                String hStr = Integer.toHexString(h);
                if (Integer.toHexString(h).length() == 1) {
                    hex.append("(byte)0x0").append(hStr).append(", ");
                    continue;
                }
                hex.append("(byte)0x").append(hStr).append(", ");
            }
            hex.append("}");
            ArLogBytes.debugout(hex.toString());
        }
    }

    public static void printByteArrayAsChar(byte[] in, String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        if (in == null || in.length == 0) {
            ArLogBytes.debugout("Byte array as char:");
        } else {
            ArLogBytes.debugout(msg);
            ArLogBytes.debugout("Byte array as char values : len = " + in.length);
            StringBuilder strB = new StringBuilder();
            for (int i = 0; i != in.length; ++i) {
                strB.append((char)in[i]).append(" ");
            }
            ArLogBytes.debugout(strB.toString());
        }
    }

    public static void printByteArray(byte[] in, int start, int bytesToRead, String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        int len = start + bytesToRead;
        if (in == null || in.length == 0 || bytesToRead <= 0 || in.length < bytesToRead) {
            ArLogBytes.debugout("Did not indicate how many bytes to log from buffer: " + in.length);
        } else {
            ArLogBytes.debugout(msg);
            StringBuilder strB = new StringBuilder();
            for (int i = start; i < len; ++i) {
                if (_lineBreak && i % 16 == 0 && i != 0) {
                    ArLogBytes.debugout(strB.toString());
                    strB = new StringBuilder();
                }
                strB.append(in[i]).append(" ");
            }
            ArLogBytes.debugout(strB.toString());
        }
    }

    public static void printByteArrayAsString(byte[] in, String msg) {
        if (!ArLogBytes.isDebugEnabled()) {
            return;
        }
        if (in == null || in.length == 0) {
            ArLogBytes.debugout("Byte array is null!");
        } else {
            ArLogBytes.debugout(msg);
            ArLogBytes.debugout("Byte array : len = " + in.length);
            ArLogBytes.debugout(new String(in));
        }
    }

    static {
        try {
            String verbose = System.getProperty("socket_bytelog_debug");
            if (verbose != null && verbose.length() > 0) {
                boolean bl = socket_bytelog_debug = "true".equalsIgnoreCase(verbose);
                if (socket_bytelog_debug) {
                    System.out.println("system property : socket_bytelog_debug = " + socket_bytelog_debug);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            byteLogFileName = "oncrpc_" + System.currentTimeMillis() + ".log";
            if (socket_bytelog_debug) {
                debugout = new PrintWriter(new FileOutputStream(byteLogFileName, true), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

