/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.io.ByteArrayInputStream;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptContentTest
extends TestCase {
    private static final String DATA = "<users>\n  <user>\n    <firstname>Bugs</firstname>\n    <lastname>Bunny</lastname>\n    <age>34</age>\n    <serial>Y10</serial>\n  </user>\n</users>\n";
    private DocumentBuilder db;
    private SecretKey secretKey;
    static /* synthetic */ Class class$org$apache$xml$security$test$encryption$EncryptContentTest;

    public static Test suite() throws Exception {
        return new TestSuite(class$org$apache$xml$security$test$encryption$EncryptContentTest == null ? (class$org$apache$xml$security$test$encryption$EncryptContentTest = EncryptContentTest.class$("org.apache.xml.security.test.encryption.EncryptContentTest")) : class$org$apache$xml$security$test$encryption$EncryptContentTest);
    }

    public EncryptContentTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
        byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
        DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
        this.secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.newTransformer();
    }

    public void testContentRemoved() throws Exception {
        Node node;
        Node node2;
        Document document = this.db.parse(new ByteArrayInputStream(DATA.getBytes("UTF8")));
        NodeList nodeList = document.getElementsByTagName("user");
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        xMLCipher.init(1, (Key)this.secretKey);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            xMLCipher.doFinal(document, (Element)nodeList.item(i), true);
        }
        Element element = (Element)nodeList.item(0);
        for (node2 = element.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        Element element2 = (Element)node2;
        if (!element2.getLocalName().equals("EncryptedData")) {
            throw new Exception("Element content not replaced");
        }
        for (node = element2.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node != null) {
            throw new Exception("Sibling element content not replaced");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

