/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrTcpEncodingStream
extends XdrEncodingStream {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    OutputStream stream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private int bufferFragmentHeaderIndex;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrTcpEncodingStream(Socket socket, int n) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getOutputStream();
        if (n < 1024) {
            n = 1024;
        }
        if ((n & 3) != 0) {
            n = n + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n];
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = n - 4;
    }

    protected XdrTcpEncodingStream(Socket socket, byte[] byArray) throws IOException {
        this.socket = socket;
        this.stream = this.socket.getOutputStream();
        this.buffer = byArray;
        this.bufferFragmentHeaderIndex = 0;
        this.bufferIndex = 4;
        this.bufferHighmark = byArray.length - 4;
    }

    public InetAddress getSenderAddress() {
        return this.socket.getInetAddress();
    }

    public int getSenderPort() {
        return this.socket.getPort();
    }

    @Override
    public void beginEncoding(InetAddress inetAddress, int n) throws OncRpcException, IOException {
    }

    @Override
    public void endEncoding() throws OncRpcException, IOException {
        this.flush(true, false);
    }

    public void endEncoding(boolean bl) throws OncRpcException, IOException {
        this.flush(true, !bl);
    }

    private void flush(boolean bl, boolean bl2) throws OncRpcException, IOException {
        int n = this.bufferIndex - this.bufferFragmentHeaderIndex - 4;
        if (bl) {
            n |= Integer.MIN_VALUE;
        }
        this.buffer[this.bufferFragmentHeaderIndex] = (byte)(n >>> 24);
        this.buffer[this.bufferFragmentHeaderIndex + 1] = (byte)(n >>> 16);
        this.buffer[this.bufferFragmentHeaderIndex + 2] = (byte)(n >>> 8);
        this.buffer[this.bufferFragmentHeaderIndex + 3] = (byte)n;
        if (debugout != null) {
            String string = "flush: lastFragment=" + bl + " batch=" + bl2 + " bufferIndex=" + this.bufferIndex + " bufferHighmark=" + this.bufferHighmark;
            string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
            debugout.println(string);
        }
        if (!bl || !bl2 || this.bufferIndex >= this.bufferHighmark) {
            this.streamFlush(bl);
            this.bufferFragmentHeaderIndex = 0;
            this.bufferIndex = 4;
        } else {
            this.bufferFragmentHeaderIndex = this.bufferIndex;
            this.bufferIndex += 4;
        }
    }

    protected void streamFlush(boolean bl) throws IOException {
        if (debugout != null) {
            String string = "streamFlush, bytes=" + this.bufferIndex;
            string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
            debugout.println(string);
        }
        this.stream.write(this.buffer, 0, this.bufferIndex);
        this.stream.flush();
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    @Override
    public void xdrEncodeInt(int n) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.flush(false, false);
        }
        this.buffer[this.bufferIndex++] = (byte)(n >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(n >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(n >>> 8);
        this.buffer[this.bufferIndex++] = (byte)n;
    }

    @Override
    public void xdrEncodeOpaque(byte[] byArray, int n, int n2) throws OncRpcException, IOException {
        int n3 = 4 - (n2 & 3) & 3;
        while (n2 > 0) {
            int n4 = this.bufferHighmark - this.bufferIndex + 4;
            if (n4 >= n2) {
                System.arraycopy(byArray, n, this.buffer, this.bufferIndex, n2);
                this.bufferIndex += n2;
                break;
            }
            System.arraycopy(byArray, n, this.buffer, this.bufferIndex, n4);
            this.bufferIndex += n4;
            n += n4;
            n2 -= n4;
            this.flush(false, false);
        }
        System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, n3);
        this.bufferIndex += n3;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    protected void setBufferIndex(int n) {
        this.bufferIndex = n;
    }

    protected void setBufferHighmark(int n) {
        this.bufferHighmark = n;
    }

    protected void replaceBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    protected byte[] getBufferArray() {
        return this.buffer;
    }
}

