/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.mail.cos;

import com.bmc.thirdparty.org.springframework.mail.MailException;
import com.bmc.thirdparty.org.springframework.mail.MailParseException;
import com.bmc.thirdparty.org.springframework.mail.MailSendException;
import com.bmc.thirdparty.org.springframework.mail.MailSender;
import com.bmc.thirdparty.org.springframework.mail.SimpleMailMessage;
import com.oreilly.servlet.MailMessage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;

public class CosMailSenderImpl
implements MailSender {
    private String host;

    public void setHost(String host) {
        this.host = host;
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        HashMap<SimpleMailMessage, IOException> failedMessages = new HashMap<SimpleMailMessage, IOException>();
        for (int i2 = 0; i2 < simpleMessages.length; ++i2) {
            SimpleMailMessage simpleMessage = simpleMessages[i2];
            if (simpleMessage.getReplyTo() != null) {
                throw new MailParseException("CosMailSenderImpl does not support replyTo field - " + simpleMessage);
            }
            if (simpleMessage.getSentDate() != null) {
                throw new MailParseException("CosMailSenderImpl does not support sentDate field - " + simpleMessage);
            }
            try {
                int j2;
                MailMessage cosMessage = new MailMessage(this.host);
                cosMessage.from(simpleMessage.getFrom());
                if (simpleMessage.getTo() != null) {
                    for (j2 = 0; j2 < simpleMessage.getTo().length; ++j2) {
                        cosMessage.to(simpleMessage.getTo()[j2]);
                    }
                }
                if (simpleMessage.getCc() != null) {
                    for (j2 = 0; j2 < simpleMessage.getCc().length; ++j2) {
                        cosMessage.cc(simpleMessage.getCc()[j2]);
                    }
                }
                if (simpleMessage.getBcc() != null) {
                    for (j2 = 0; j2 < simpleMessage.getBcc().length; ++j2) {
                        cosMessage.bcc(simpleMessage.getBcc()[j2]);
                    }
                }
                cosMessage.setSubject(simpleMessage.getSubject());
                PrintStream textStream = cosMessage.getPrintStream();
                textStream.print(simpleMessage.getText());
                cosMessage.sendAndClose();
                continue;
            }
            catch (IOException ex) {
                failedMessages.put(simpleMessage, ex);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }
}

