/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.SimpleTypeConverter;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanCreationException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanDefinitionStoreException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bmc.thirdparty.org.springframework.beans.factory.config.RuntimeBeanNameReference;
import com.bmc.thirdparty.org.springframework.beans.factory.config.RuntimeBeanReference;
import com.bmc.thirdparty.org.springframework.beans.factory.config.TypedStringValue;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.ManagedList;
import com.bmc.thirdparty.org.springframework.beans.factory.support.ManagedMap;
import com.bmc.thirdparty.org.springframework.beans.factory.support.ManagedProperties;
import com.bmc.thirdparty.org.springframework.beans.factory.support.ManagedSet;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.core.CollectionFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class BeanDefinitionValueResolver {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AbstractBeanFactory beanFactory;
    private final String beanName;
    private final BeanDefinition beanDefinition;
    private final SimpleTypeConverter typeConverter = new SimpleTypeConverter();

    public BeanDefinitionValueResolver(AbstractBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition) {
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        this.beanFactory = beanFactory;
        beanFactory.registerCustomEditors(this.typeConverter);
    }

    public Object resolveValueIfNecessary(String argName, Object value) throws BeansException {
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
            return this.resolveInnerBeanDefinition(argName, bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.resolveInnerBeanDefinition(argName, "(inner bean)", bd);
        }
        if (value instanceof RuntimeBeanNameReference) {
            String ref = ((RuntimeBeanNameReference)value).getBeanName();
            if (!this.beanFactory.containsBean(ref)) {
                throw new BeanDefinitionStoreException("Invalid bean name '" + ref + "' in bean reference for " + argName);
            }
            return ref;
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(argName, ref);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(argName, (List)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(argName, (Set)value);
        }
        if (value instanceof ManagedMap) {
            return this.resolveManagedMap(argName, (Map)value);
        }
        if (value instanceof ManagedProperties) {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)((Properties)value));
            return copy;
        }
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            try {
                Class resolvedTargetType = this.resolveTargetType(typedStringValue);
                return this.beanFactory.doTypeConversionIfNecessary(this.typeConverter, typedStringValue.getValue(), resolvedTargetType, null);
            }
            catch (Throwable ex) {
                throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting typed String value for " + argName, ex);
            }
        }
        return value;
    }

    protected Class resolveTargetType(TypedStringValue value) throws ClassNotFoundException {
        if (value.hasTargetType()) {
            return value.getTargetType();
        }
        return value.resolveTargetType(this.beanFactory.getBeanClassLoader());
    }

    private Object resolveInnerBeanDefinition(String argName, String innerBeanName, BeanDefinition innerBd) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving inner bean definition '" + innerBeanName + "' of bean '" + this.beanName + "'");
        }
        try {
            RootBeanDefinition mergedInnerBd = this.beanFactory.getMergedBeanDefinition(innerBeanName, innerBd);
            String actualInnerBeanName = innerBeanName;
            if (mergedInnerBd.isSingleton()) {
                if (!this.beanDefinition.isSingleton()) {
                    throw new BeanDefinitionStoreException("Inner bean definition '" + innerBeanName + "' for " + argName + " has scope 'singleton' but containing bean definition '" + this.beanName + "' does not. Mark the inner bean definition with scope 'prototype' instead.");
                }
                actualInnerBeanName = this.adaptInnerBeanName(innerBeanName);
            }
            Object innerBean = this.beanFactory.createBean(actualInnerBeanName, mergedInnerBd, null);
            if (mergedInnerBd.isSingleton()) {
                this.beanFactory.registerDependentBean(actualInnerBeanName, this.beanName);
            }
            return this.beanFactory.getObjectForBeanInstance(innerBean, actualInnerBeanName, mergedInnerBd);
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot create inner bean '" + innerBeanName + "' while setting " + argName, ex);
        }
    }

    private String adaptInnerBeanName(String innerBeanName) {
        String actualInnerBeanName = innerBeanName;
        int counter = 0;
        while (this.beanFactory.isBeanNameUsed(actualInnerBeanName)) {
            actualInnerBeanName = innerBeanName + GENERATED_BEAN_NAME_SEPARATOR + ++counter;
        }
        return actualInnerBeanName;
    }

    private Object resolveReference(String argName, RuntimeBeanReference ref) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving reference from property " + argName + " in bean '" + this.beanName + "' to bean '" + ref.getBeanName() + "'");
        }
        try {
            if (ref.isToParent()) {
                if (this.beanFactory.getParentBeanFactory() == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' in parent factory: no parent factory available");
                }
                return this.beanFactory.getParentBeanFactory().getBean(ref.getBeanName());
            }
            Object bean = this.beanFactory.getBean(ref.getBeanName());
            if (this.beanDefinition.isSingleton()) {
                this.beanFactory.registerDependentBean(ref.getBeanName(), this.beanName);
            }
            return bean;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean '" + ref.getBeanName() + "' while setting " + argName, ex);
        }
    }

    private List resolveManagedList(String argName, List ml) throws BeansException {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i2 = 0; i2 < ml.size(); ++i2) {
            resolved.add(this.resolveValueIfNecessary(argName + " with key " + "[" + i2 + "]", ml.get(i2)));
        }
        return resolved;
    }

    private Set resolveManagedSet(String argName, Set ms) throws BeansException {
        Set resolved = CollectionFactory.createLinkedSetIfPossible(ms.size());
        int i2 = 0;
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(argName + " with key " + "[" + i2 + "]", it.next()));
            ++i2;
        }
        return resolved;
    }

    private Map resolveManagedMap(String argName, Map mm) throws BeansException {
        Map resolved = CollectionFactory.createLinkedMapIfPossible(mm.size());
        Iterator it = mm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object resolvedKey = this.resolveValueIfNecessary(argName, entry.getKey());
            Object resolvedValue = this.resolveValueIfNecessary(argName + " with key " + "[" + entry.getKey() + "]", entry.getValue());
            resolved.put(resolvedKey, resolvedValue);
        }
        return resolved;
    }
}

