/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcUdpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.XdrUdpDecodingStream;
import org.acplt.oncrpc.XdrUdpEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public class OncRpcUdpServerTransport
extends OncRpcServerTransport {
    private DatagramSocket socket;
    private OncRpcUdpSocketHelper socketHelper;
    private XdrUdpEncodingStream sendingXdr;
    private XdrUdpDecodingStream receivingXdr;
    private boolean pendingDecoding = false;

    public OncRpcUdpServerTransport(OncRpcDispatchable oncRpcDispatchable, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(oncRpcDispatchable, n, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(n2, n3)}, n4);
    }

    public OncRpcUdpServerTransport(OncRpcDispatchable oncRpcDispatchable, int n, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n2) throws OncRpcException, IOException {
        this(oncRpcDispatchable, null, n, oncRpcServerTransportRegistrationInfoArray, n2);
    }

    public OncRpcUdpServerTransport(OncRpcDispatchable oncRpcDispatchable, InetAddress inetAddress, int n, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n2) throws OncRpcException, IOException {
        super(oncRpcDispatchable, n, oncRpcServerTransportRegistrationInfoArray);
        if (n2 < 1024) {
            n2 = 1024;
        }
        this.socket = new DatagramSocket(n, inetAddress);
        this.socketHelper = new OncRpcUdpSocketHelper(this.socket);
        if (n == 0) {
            this.port = this.socket.getLocalPort();
        }
        if (this.socketHelper.getSendBufferSize() < n2) {
            this.socketHelper.setSendBufferSize(n2);
        }
        if (this.socketHelper.getReceiveBufferSize() < n2) {
            this.socketHelper.setReceiveBufferSize(n2);
        }
        this.sendingXdr = new XdrUdpEncodingStream(this.socket, n2);
        this.receivingXdr = new XdrUdpDecodingStream(this.socket, n2);
    }

    @Override
    public void close() {
        Object object;
        if (this.socket != null) {
            object = this.socket;
            this.socket = null;
            ((DatagramSocket)object).close();
        }
        if (this.sendingXdr != null) {
            object = this.sendingXdr;
            this.sendingXdr = null;
            try {
                ((XdrEncodingStream)object).close();
            }
            catch (IOException iOException) {
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
        }
        if (this.receivingXdr != null) {
            object = this.receivingXdr;
            this.receivingXdr = null;
            try {
                ((XdrDecodingStream)object).close();
            }
            catch (IOException iOException) {
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
        }
    }

    @Override
    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getLocalHost());
            int n = this.info.length;
            for (int i = 0; i < n; ++i) {
                if (oncRpcPortmapClient.setPort(this.info[i].program, this.info[i].version, 17, this.port)) continue;
                throw new OncRpcException(45);
            }
        }
        catch (IOException iOException) {
            throw new OncRpcException(16);
        }
    }

    @Override
    protected void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        xdrAble.xdrDecode(this.receivingXdr);
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    @Override
    protected XdrDecodingStream getXdrDecodingStream() {
        return this.receivingXdr;
    }

    @Override
    protected void endDecoding() throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    @Override
    protected XdrEncodingStream getXdrEncodingStream() {
        return this.sendingXdr;
    }

    @Override
    protected void beginEncoding(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage) throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
        this.sendingXdr.beginEncoding(oncRpcCallInformation.peerAddress, oncRpcCallInformation.peerPort);
        oncRpcServerReplyMessage.xdrEncode(this.sendingXdr);
    }

    @Override
    protected void endEncoding() throws OncRpcException, IOException {
        this.sendingXdr.endEncoding();
    }

    @Override
    protected void reply(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage, XdrAble xdrAble) throws OncRpcException, IOException {
        this.beginEncoding(oncRpcCallInformation, oncRpcServerReplyMessage);
        if (xdrAble != null) {
            xdrAble.xdrEncode(this.sendingXdr);
        }
        this.endEncoding();
    }

    @Override
    public void listen() {
        Thread thread = new Thread("UDP server transport listener thread"){

            @Override
            public void run() {
                OncRpcUdpServerTransport.this._listen();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void _listen() {
        OncRpcCallInformation oncRpcCallInformation = new OncRpcCallInformation(this);
        while (true) {
            try {
                this.pendingDecoding = true;
                this.receivingXdr.beginDecoding();
                oncRpcCallInformation.peerAddress = this.receivingXdr.getSenderAddress();
                oncRpcCallInformation.peerPort = this.receivingXdr.getSenderPort();
            }
            catch (IOException iOException) {
                this.close();
                return;
            }
            catch (OncRpcException oncRpcException) {
                continue;
            }
            try {
                oncRpcCallInformation.callMessage.xdrDecode(this.receivingXdr);
            }
            catch (IOException iOException) {
                this.close();
                return;
            }
            catch (OncRpcException oncRpcException) {
                if (!this.pendingDecoding) continue;
                this.pendingDecoding = false;
                try {
                    this.receivingXdr.endDecoding();
                    continue;
                }
                catch (IOException iOException) {
                    this.close();
                    return;
                }
                catch (OncRpcException oncRpcException2) {
                    continue;
                }
            }
            try {
                this.dispatcher.dispatchOncRpcCall(oncRpcCallInformation, oncRpcCallInformation.callMessage.program, oncRpcCallInformation.callMessage.version, oncRpcCallInformation.callMessage.procedure);
                continue;
            }
            catch (Exception exception) {
                if (this.pendingDecoding) {
                    this.pendingDecoding = false;
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException iOException) {
                        this.close();
                        return;
                    }
                    catch (OncRpcException oncRpcException) {
                        // empty catch block
                    }
                }
                try {
                    if (exception instanceof OncRpcAuthenticationException) {
                        oncRpcCallInformation.failAuthenticationFailed(((OncRpcAuthenticationException)exception).getAuthStatus());
                        continue;
                    }
                    oncRpcCallInformation.failSystemError();
                    continue;
                }
                catch (IOException iOException) {
                    this.close();
                    return;
                }
                catch (OncRpcException oncRpcException) {
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.sendingXdr.setCharacterEncoding(string);
        this.receivingXdr.setCharacterEncoding(string);
    }

    @Override
    public String getCharacterEncoding() {
        return this.sendingXdr.getCharacterEncoding();
    }
}

