/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.BaseConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompositeConfiguration
extends AbstractConfiguration
implements Cloneable {
    private List configList = new LinkedList();
    private Configuration inMemoryConfiguration;

    public CompositeConfiguration() {
        this.clear();
    }

    public CompositeConfiguration(Configuration inMemoryConfiguration) {
        this.configList.clear();
        this.inMemoryConfiguration = inMemoryConfiguration;
        this.configList.add(inMemoryConfiguration);
    }

    public CompositeConfiguration(Collection configurations) {
        this(new BaseConfiguration(), configurations);
    }

    public CompositeConfiguration(Configuration inMemoryConfiguration, Collection configurations) {
        this(inMemoryConfiguration);
        if (configurations != null) {
            Iterator it = configurations.iterator();
            while (it.hasNext()) {
                this.addConfiguration((Configuration)it.next());
            }
        }
    }

    public void addConfiguration(Configuration config) {
        if (!this.configList.contains(config)) {
            this.configList.add(this.configList.indexOf(this.inMemoryConfiguration), config);
            if (config instanceof AbstractConfiguration) {
                ((AbstractConfiguration)config).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
            }
        }
    }

    public void removeConfiguration(Configuration config) {
        if (!config.equals(this.inMemoryConfiguration)) {
            this.configList.remove(config);
        }
    }

    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    public void clear() {
        this.configList.clear();
        this.inMemoryConfiguration = new BaseConfiguration();
        ((BaseConfiguration)this.inMemoryConfiguration).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        this.configList.add(this.inMemoryConfiguration);
    }

    protected void addPropertyDirect(String key, Object token) {
        this.inMemoryConfiguration.addProperty(key, token);
    }

    public Object getProperty(String key) {
        Configuration firstMatchingConfiguration = null;
        Iterator i2 = this.configList.iterator();
        while (i2.hasNext()) {
            Configuration config = (Configuration)i2.next();
            if (!config.containsKey(key)) continue;
            firstMatchingConfiguration = config;
            break;
        }
        if (firstMatchingConfiguration != null) {
            return firstMatchingConfiguration.getProperty(key);
        }
        return null;
    }

    public Iterator getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator i2 = this.configList.iterator();
        while (i2.hasNext()) {
            Configuration config = (Configuration)i2.next();
            Iterator j2 = config.getKeys();
            while (j2.hasNext()) {
                String key = (String)j2.next();
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return keys.iterator();
    }

    public Iterator getKeys(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator i2 = this.configList.iterator();
        while (i2.hasNext()) {
            Configuration config = (Configuration)i2.next();
            Iterator j2 = config.getKeys(key);
            while (j2.hasNext()) {
                String newKey = (String)j2.next();
                if (keys.contains(newKey)) continue;
                keys.add(newKey);
            }
        }
        return keys.iterator();
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        Iterator i2 = this.configList.iterator();
        while (i2.hasNext()) {
            Configuration config = (Configuration)i2.next();
            if (config.isEmpty()) continue;
            return false;
        }
        return isEmpty;
    }

    public void clearProperty(String key) {
        Iterator i2 = this.configList.iterator();
        while (i2.hasNext()) {
            Configuration config = (Configuration)i2.next();
            config.clearProperty(key);
        }
    }

    public boolean containsKey(String key) {
        Iterator i2 = this.configList.iterator();
        while (i2.hasNext()) {
            Configuration config = (Configuration)i2.next();
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public List getList(String key, List defaultValue) {
        ArrayList list = new ArrayList();
        Iterator it = this.configList.iterator();
        while (it.hasNext() && list.isEmpty()) {
            Configuration config = (Configuration)it.next();
            if (config == this.inMemoryConfiguration || !config.containsKey(key)) continue;
            list.addAll(config.getList(key));
        }
        list.addAll(this.inMemoryConfiguration.getList(key));
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list;
    }

    public String[] getStringArray(String key) {
        List list = this.getList(key);
        String[] tokens = new String[list.size()];
        int i2 = 0;
        while (i2 < tokens.length) {
            tokens[i2] = this.interpolate(String.valueOf(list.get(i2)));
            ++i2;
        }
        return tokens;
    }

    public Configuration getConfiguration(int index) {
        return (Configuration)this.configList.get(index);
    }

    public Configuration getInMemoryConfiguration() {
        return this.inMemoryConfiguration;
    }

    public Object clone() {
        try {
            CompositeConfiguration copy = (CompositeConfiguration)super.clone();
            copy.clearConfigurationListeners();
            copy.configList = new LinkedList();
            copy.inMemoryConfiguration = ConfigurationUtils.cloneConfiguration(this.getInMemoryConfiguration());
            copy.configList.add(copy.inMemoryConfiguration);
            int i2 = 0;
            while (i2 < this.getNumberOfConfigurations()) {
                Configuration config = this.getConfiguration(i2);
                if (config != this.getInMemoryConfiguration()) {
                    copy.addConfiguration(ConfigurationUtils.cloneConfiguration(config));
                }
                ++i2;
            }
            return copy;
        }
        catch (CloneNotSupportedException cnex) {
            throw new ConfigurationRuntimeException(cnex);
        }
    }
}

