/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.artranscode;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ARCharSet {
    static Map<String, String> langCharSetMap;
    static Map<String, String> serverCharsetStringMap;
    static final Pattern pWindows;
    static final Pattern pUnix;
    private static Logger a;

    public static String getServerCharSetName(String string) {
        a.debug("serverLanguage = " + string);
        int n2 = string.indexOf(";");
        String string2 = null;
        String string3 = null;
        if (n2 > -1) {
            string3 = string.substring(n2 + 1);
        }
        if (string3 != null) {
            String string4 = langCharSetMap.get(string3);
            if (string4 != null) {
                string2 = string4;
            } else {
                string4 = ARCharSet.a(string3);
                if (string4 != null) {
                    string2 = string4;
                } else if (string3.contains("UTF_8") || string3.contains("UTF-8")) {
                    string2 = "UTF-8";
                } else if (string3.contains("UTF_16") || string3.contains("UTF-16")) {
                    string2 = "UTF-16";
                } else if (string3.contains("WESTERN")) {
                    string2 = "windows-1252";
                } else if (string3.equals("SJIS")) {
                    string2 = "windows-31j";
                } else if (string3.contains("Shift-JIS") || string3.contains("Shift_JIS")) {
                    string2 = "windows-31j";
                } else if (string3.contains("EUC_C") || string3.contains("EUC_ZH")) {
                    string2 = "EUC_CN";
                } else if (string3.contains("EUC_H") || string3.contains("EUC_TW")) {
                    string2 = "EUC_TW";
                } else if (string3.contains("EUC_K") || string3.contains("EUC-K")) {
                    string2 = "EUC_KR";
                } else if (string3.contains("EUC")) {
                    string2 = "EUC_JP";
                } else if (string3.contains("GB")) {
                    string2 = "GB2312";
                } else if (string3.contains("BIG5")) {
                    string2 = "Big5";
                } else if (string3.contains("KSC_5601")) {
                    string2 = "EUC_KR";
                } else if (string3.contains("874")) {
                    string2 = "windows-874";
                }
            }
        }
        if (string2 == null) {
            string2 = "utf-8";
        }
        a.debug("svrCharSetJavaName = " + string2);
        return string2;
    }

    private static String a(String string) {
        String string2 = null;
        Matcher matcher = pWindows.matcher(string);
        if (matcher.find() || (matcher = pUnix.matcher(string)).find()) {
            String string3 = matcher.group(1);
            a.debug(string3);
            string2 = langCharSetMap.get(string3);
        }
        return string2;
    }

    public static String getServerKnownCodeSet(String string) {
        if ("windows-31j".equalsIgnoreCase(string) || "SJIS".equalsIgnoreCase(string)) {
            return "shift_jis";
        }
        return ARCharSet.getServerKnownCharSetString(string);
    }

    public static String getServerKnownCharSetString(String string) {
        String string2 = null;
        string2 = serverCharsetStringMap.get(string.toLowerCase());
        if (string2 == null) {
            string2 = "utf-8".toUpperCase();
        }
        return string2;
    }

    static {
        pWindows = Pattern.compile("(125\\d)");
        pUnix = Pattern.compile("(8859[\\-_]\\d+)");
        a = Logger.getLogger(ARCharSet.class);
        langCharSetMap = new HashMap<String, String>();
        langCharSetMap.put("8859-11", "windows-874");
        langCharSetMap.put("8859_11", "windows-874");
        langCharSetMap.put("8859-15", "windows-1252");
        langCharSetMap.put("8859_15", "windows-1252");
        langCharSetMap.put("8859-1", "windows-1252");
        langCharSetMap.put("8859_1", "windows-1252");
        langCharSetMap.put("8859-2", "windows-1250");
        langCharSetMap.put("8859_2", "windows-1250");
        langCharSetMap.put("8859-3", "ISO-8859-3");
        langCharSetMap.put("8859-4", "windows-1257");
        langCharSetMap.put("8859_4", "windows-1257");
        langCharSetMap.put("8859-5", "windows-1251");
        langCharSetMap.put("8859_5", "windows-1251");
        langCharSetMap.put("8859-6", "windows-1256");
        langCharSetMap.put("8859_6", "windows-1256");
        langCharSetMap.put("8859-7", "windows-1253");
        langCharSetMap.put("8859_7", "windows-1253");
        langCharSetMap.put("8859-8", "windows-1255");
        langCharSetMap.put("8859_8", "windows-1255");
        langCharSetMap.put("8859-9", "windows-1254");
        langCharSetMap.put("8859_9", "windows-1254");
        langCharSetMap.put("1250", "windows-1250");
        langCharSetMap.put("1251", "windows-1251");
        langCharSetMap.put("1252", "windows-1252");
        langCharSetMap.put("1253", "windows-1253");
        langCharSetMap.put("1254", "windows-1254");
        langCharSetMap.put("1255", "windows-1255");
        langCharSetMap.put("1256", "windows-1256");
        langCharSetMap.put("1257", "windows-1257");
        langCharSetMap.put("1258", "windows-1258");
        langCharSetMap.put("SJIS", "windows-31j");
        langCharSetMap.put("Shift-JIS", "windows-31j");
        langCharSetMap.put("Shift_JIS", "windows-31j");
        langCharSetMap.put("shift_jis", "windows-31j");
        langCharSetMap.put("UTF-8", "UTF-8");
        langCharSetMap.put("UTF_8", "UTF-8");
        langCharSetMap.put("UTF-16", "UTF-16");
        langCharSetMap.put("UTF_16", "UTF-16");
        langCharSetMap.put("WESTERN", "windows-1252");
        langCharSetMap.put("EUC_C", "EUC_CN");
        langCharSetMap.put("EUC_ZH", "EUC_CN");
        langCharSetMap.put("EUC_H", "EUC_TW");
        langCharSetMap.put("ENC_TW", "EUC_TW");
        langCharSetMap.put("EUC-K", "EUC_KR");
        langCharSetMap.put("EUC_K", "EUC_KR");
        langCharSetMap.put("EUC", "EUC_JP");
        langCharSetMap.put("GB", "GB2312");
        langCharSetMap.put("GB2312", "GB2312");
        langCharSetMap.put("GB-2312", "GB2312");
        langCharSetMap.put("GB_2312", "GB2312");
        langCharSetMap.put("GB2313", "GB2312");
        langCharSetMap.put("GB-2313", "GB2312");
        langCharSetMap.put("GB_2313", "GB2312");
        langCharSetMap.put("BIG5", "Big5");
        langCharSetMap.put("KSC_5601", "windows-1258");
        langCharSetMap.put("874", "windows-874");
        serverCharsetStringMap = new HashMap<String, String>();
        serverCharsetStringMap.put("utf-8", "UTF-8");
        serverCharsetStringMap.put("utf-16", "UTF-16");
        serverCharsetStringMap.put("cp1252", "windows-1252");
        serverCharsetStringMap.put("windows-1252", "windows-1252");
        serverCharsetStringMap.put("euc-tw", "EUC_H");
        serverCharsetStringMap.put("euc-cn", "EUC_C");
        serverCharsetStringMap.put("euc-jp", "EUC_JP");
        serverCharsetStringMap.put("shift_jis", "Shift_JIS");
        serverCharsetStringMap.put("jis", "JIS");
        serverCharsetStringMap.put("gb2312", "GB2312");
        serverCharsetStringMap.put("big5", "Big5");
        serverCharsetStringMap.put("cp949", "KSC_5601_92");
        serverCharsetStringMap.put("windows-1250", "windows-1250");
        serverCharsetStringMap.put("windows-1251", "windows-1251");
        serverCharsetStringMap.put("windows-1253", "windows-1253");
        serverCharsetStringMap.put("windows-1254", "windows-1254");
        serverCharsetStringMap.put("windows-1255", "windows-1255");
        serverCharsetStringMap.put("windows-1256", "windows-1256");
        serverCharsetStringMap.put("windows-1257", "windows-1257");
        serverCharsetStringMap.put("windows-1258", "windows-1258");
        serverCharsetStringMap.put("iso-8859-1", "ISO-8859-1");
        serverCharsetStringMap.put("iso-8859-2", "ISO-8859-2");
        serverCharsetStringMap.put("iso-8859-3", "ISO-8859-3");
        serverCharsetStringMap.put("iso-8859-4", "ISO-8859-4");
        serverCharsetStringMap.put("iso-8859-5", "ISO-8859-5");
        serverCharsetStringMap.put("iso-8859-6", "ISO-8859-6");
        serverCharsetStringMap.put("iso-8859-7", "ISO-8859-7");
        serverCharsetStringMap.put("iso-8859-8", "ISO-8859-8");
        serverCharsetStringMap.put("iso-8859-9", "ISO-8859-9");
        serverCharsetStringMap.put("cp874", "windows-874");
    }
}

