/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ARStructMapTypeInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

@ARStructMapTypeInfo(KeyType="java.lang.Integer", KeyIndex={0}, ValueType="com.bmc.arsys.api.Value", ValueIndex={1})
public class Entry
extends LinkedHashMap<Integer, Value>
implements Serializable {
    private static final long serialVersionUID = -1287560156290121395L;
    private static Logger a = Logger.getLogger(Entry.class);

    public Entry() {
    }

    public Entry(Map<? extends Integer, ? extends Value> map) {
        super(map);
    }

    public Entry(SortedMap<Integer, ? extends Value> sortedMap) {
        super(sortedMap);
    }

    public String getKey() {
        return this.getEntryId();
    }

    public String getEntryId() {
        Value value;
        if (this.containsKey(CoreFieldId.EntryId.getFieldId()) && (value = (Value)this.get(CoreFieldId.EntryId.getFieldId())) != null) {
            return (String)value.getValue();
        }
        return null;
    }

    public String getEntryIdWithNoSeparator() {
        String string = this.getEntryId();
        if (string != null) {
            return string.replace("|", "");
        }
        return string;
    }

    public void setEntryId(String string) {
        this.put(CoreFieldId.EntryId.getFieldId(), new Value(string));
    }

    public static String[] splitEntryId(String string) {
        return Entry.splitEntryId(string, "utf-8");
    }

    public static String[] splitEntryId(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (string.contains("|")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
            int n2 = stringTokenizer.countTokens();
            boolean bl = false;
            if (n2 > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals("|")) {
                        if (bl) {
                            arrayList.add("");
                        }
                        bl = true;
                        continue;
                    }
                    bl = false;
                    arrayList.add(string3);
                }
                if (bl) {
                    arrayList.add("");
                }
                return arrayList.toArray(new String[0]);
            }
            return new String[]{string};
        }
        return StringByteUtil.splitString(string, 15, string2);
    }

    public static String prepareEntryId(Object[] objectArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n3 = n2 = objectArray != null ? objectArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = null;
            if (objectArray[i2] instanceof Object[] && ((Object[])objectArray[i2]).length > 1) {
                throw new IllegalArgumentException(CatalogReader.getInstance().getMessage(4564));
            }
            if (objectArray[i2] != null) {
                string = objectArray[i2].toString();
                if (string.length() <= 0) continue;
                if (bl) {
                    stringBuilder.append("|");
                } else {
                    bl = true;
                }
                stringBuilder.append(string);
                continue;
            }
            throw new IllegalArgumentException(CatalogReader.getInstance().getMessage(4564));
        }
        return stringBuilder.toString();
    }

    static List<Entry> buildGLEWFResponse(ARServerUser aRServerUser, byte[] byArray, String string, OutputInteger outputInteger) throws ARException {
        int n2;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        a.trace("buildGLEWFResponse:serverCharSetName:" + string);
        if (byArray == null) {
            return arrayList;
        }
        String string2 = null;
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            a.error(unsupportedEncodingException);
            throw new ARException(2, 9061, unsupportedEncodingException.getLocalizedMessage());
        }
        a.trace("buildGLEWFResponse: buffer len=" + string2.length());
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string2.indexOf("\n", n5);
        if (n6 > 0) {
            try {
                n3 = new Integer(string2.substring(n5, n6));
            }
            catch (NumberFormatException numberFormatException) {
                a.debug("NFE occurs at index [" + n5 + "] for # of entries. " + string2.substring(n5));
                Entry.a(string2);
                throw numberFormatException;
            }
        } else {
            a.error("ERROR: Unable to parse GLEWF result buffer for the # of entries. " + string2.substring(n5));
            return arrayList;
        }
        n5 = n6 + 1;
        n6 = string2.indexOf("\n", n5);
        if (n6 > 0) {
            if (outputInteger != null) {
                try {
                    outputInteger.setValue(new Long(string2.substring(n5, n6)));
                }
                catch (NumberFormatException numberFormatException) {
                    a.debug("NFE occurs at index [" + n5 + "] for # of matches. " + string2.substring(n5));
                    Entry.a(string2);
                    throw numberFormatException;
                }
            }
        } else {
            a.error("ERROR: Unable to parse GLEWF result buffer for the # of matches. " + string2.substring(n5));
            return arrayList;
        }
        if ((n6 = string2.indexOf("\n", n5 = n6 + 1)) > 0) {
            try {
                n4 = new Integer(string2.substring(n5, n6));
            }
            catch (NumberFormatException numberFormatException) {
                a.debug("NFE occurs at index [" + n5 + "] for # of fields per entry. " + string2.substring(n5));
                Entry.a(string2);
                throw numberFormatException;
            }
        } else {
            a.error("ERROR: Unable to parse GLEWF result buffer for the # of fields per entry. " + string2.substring(n5));
            return arrayList;
        }
        if (a.isTraceEnabled()) {
            a.trace("buildGLEWFResponse: numEntries=" + n3 + " nMatches=" + (outputInteger != null ? outputInteger : Integer.valueOf(0)) + " numFieldsPerEntry=" + n4);
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n2 = 0; n2 < n4; ++n2) {
            n5 = n6 + 1;
            if ((n6 = string2.indexOf("\n", n5)) > 0) {
                try {
                    linkedList.add(new Integer(string2.substring(n5, n6)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    a.debug("NFE occurs at index [" + n5 + "] for field Ids. " + string2.substring(n5));
                    Entry.a(string2);
                    throw numberFormatException;
                }
            }
            a.error("ERROR: Unable to parse GLEWF result buffer for field Ids. " + string2.substring(n5));
            return arrayList;
        }
        OutputInteger outputInteger2 = new OutputInteger();
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            Value value;
            Entry entry = aRServerUser != null && aRServerUser.getExtendedClassRegistry() != null && aRServerUser.getExtendedClassRegistry().isExtendingClassRegistered(Entry.class) ? (Entry)((Object)aRServerUser.getExtendedClassRegistry().newInstance(Entry.class)) : new Entry();
            n5 = n6 + 1;
            if ((n6 = string2.indexOf("\n", n5)) > 0) {
                String string3 = string2.substring(n5, n6);
                value = new Value(string3);
                entry.put(CoreFieldId.EntryId.getFieldId(), value);
                try {
                    n7 += string3.getBytes(string).length - (n6 - n5);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    a.error(unsupportedEncodingException);
                    throw new ARException(2, 9062, unsupportedEncodingException.getLocalizedMessage());
                }
            } else {
                a.error("ERROR: Unable to parse GLEWF result buffer for the entry Id. " + string2.substring(n5));
                return arrayList;
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                int n8;
                int n9;
                int n10;
                n2 = (Integer)linkedList.get(i3);
                if (n2 == CoreFieldId.EntryId.getFieldId()) continue;
                n5 = n6 + 1;
                if ((n6 = string2.indexOf("\\", n5)) > 0) {
                    try {
                        n10 = new Integer(string2.substring(n5, n6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        a.debug("NFE occurs at index [" + n5 + "] for the datatype." + string2.substring(n5));
                        Entry.a(string2);
                        throw numberFormatException;
                    }
                } else {
                    a.error("ERROR: Unable to parse GLEWF result buffer for the dataType. " + string2.substring(n5));
                    return arrayList;
                }
                n5 = n6 + 1;
                n6 = string2.indexOf("\\", n5);
                if (n6 > 0) {
                    try {
                        n9 = new Integer(string2.substring(n5, n6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        a.debug("NFE occurs at index [" + n5 + "] for the value length." + string2.substring(n5));
                        Entry.a(string2);
                        throw numberFormatException;
                    }
                } else {
                    a.error("ERROR: Unable to parse GLEWF result buffer for the value length. " + string2.substring(n5));
                    return arrayList;
                }
                n5 = n6 + 1;
                if (n9 > 0) {
                    value = Value.deserializeFromBytesBuffer(byArray, n5 + n7, n9, n10, string, outputInteger2);
                    n8 = outputInteger2.intValue();
                    n7 += n9 - n8;
                } else {
                    value = new Value();
                    n8 = 0;
                }
                entry.put(n2, value);
                n6 = n5 + n8;
            }
            arrayList.add(entry);
        }
        return arrayList;
    }

    static List<Entry> buildGMEResponse(Object[] objectArray, List<String> list, ARServerUser aRServerUser) throws ARException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        if (objectArray == null) {
            a.error("ERROR: Entry.buildGMEResponse rawData is null");
            return arrayList;
        }
        Object[] objectArray2 = (Object[])objectArray[6];
        Object[] objectArray3 = (Object[])objectArray[7];
        assert (objectArray2 != null && objectArray3 != null && objectArray2.length == objectArray3.length);
        int n2 = objectArray3.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray4 = (Object[])objectArray3[i2];
            if (ConversionUtil.getBooleanValue(objectArray2[i2]) && objectArray4.getClass().isArray()) {
                Object[] objectArray5 = objectArray4;
                Entry entry = ARTypeMgr.getInstance().ObjectFromVariant(Entry.class, objectArray5, aRServerUser);
                entry.setEntryId(list.get(i2));
                arrayList.add(entry);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    @Override
    public Object clone() {
        Entry entry = (Entry)super.clone();
        for (Integer n2 : this.keySet()) {
            Value value = (Value)this.get(n2);
            Value value2 = null;
            if (value != null) {
                try {
                    value2 = (Value)value.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    value2 = new Value(value.getValue().toString(), value.getDataType());
                }
            }
            entry.put(new Integer(n2), value2);
        }
        return entry;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Entry)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return new EqualsBuilder().appendSuper(super.equals(object)).isEquals();
    }

    private void a(Value value) {
        if (value != null) {
            int n2 = value.getType();
            if (n2 != 4 && n2 != 0) {
                a.error("ERROR: EntryId val.type can not be " + n2);
                throw new IllegalArgumentException(CatalogReader.getInstance().getMessage(4564));
            }
            String string = (String)value.getValue();
            Entry.splitEntryId(string);
        }
    }

    @Override
    public Value put(Integer n2, Value value) {
        if (n2.intValue() == CoreFieldId.EntryId.getFieldId()) {
            this.a(value);
        }
        return super.put(n2, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Value> map) {
        if (map.containsKey(CoreFieldId.EntryId.getFieldId())) {
            Value value = map.get(CoreFieldId.EntryId.getFieldId());
            this.a(value);
        }
        super.putAll(map);
    }

    private static void a(String string) {
        String string2 = string.replace("\\", "\\\\");
        string2 = string2.replace("\n", "\\n");
        a.debug("The complete buffer contents=" + string2);
    }
}

