/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrBufferEncodingStream
extends XdrEncodingStream {
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrBufferEncodingStream(int n2) {
        if (n2 < 0 || (n2 & 3) != 0) {
            throw new IllegalArgumentException("size of buffer must be a multiple of four and must not be negative");
        }
        this.buffer = new byte[n2];
        this.bufferIndex = 0;
        this.bufferHighmark = this.buffer.length - 4;
    }

    public XdrBufferEncodingStream(byte[] byArray) {
        if ((byArray.length & 3) != 0) {
            throw new IllegalArgumentException("size of buffer must be a multiple of four");
        }
        this.buffer = byArray;
        this.bufferIndex = 0;
        this.bufferHighmark = byArray.length - 4;
    }

    public int getXdrLength() {
        return this.bufferIndex;
    }

    public byte[] getXdrData() {
        return this.buffer;
    }

    @Override
    public void beginEncoding(InetAddress inetAddress, int n2) throws OncRpcException, IOException {
        this.bufferIndex = 0;
    }

    @Override
    public void endEncoding() throws OncRpcException, IOException {
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    @Override
    public void xdrEncodeInt(int n2) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            throw new OncRpcException(42);
        }
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 8);
        this.buffer[this.bufferIndex++] = (byte)n2;
    }

    @Override
    public void xdrEncodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = 4 - (n3 & 3) & 3;
        if (this.bufferIndex <= this.bufferHighmark - (n3 + n4)) {
            System.arraycopy(byArray, n2, this.buffer, this.bufferIndex, n3);
            this.bufferIndex += n3;
            if (n4 != 0) {
                System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, n4);
                this.bufferIndex += n4;
            }
        } else {
            throw new OncRpcException(42);
        }
    }
}

