/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.toplink.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import oracle.toplink.sessions.DefaultSessionLog;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionLogEntry;

public class CommonsLoggingSessionLog904
extends DefaultSessionLog {
    public static final String NAMESPACE = "oracle.toplink.session";
    public static final String DEFAULT_SEPARATOR = "--";
    private final Log logger = LogFactory.getLog("oracle.toplink.session");
    private String separator = "--";

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void log(SessionLogEntry entry) {
        if (entry.hasException()) {
            if (this.shouldLogExceptions() && this.logger.isWarnEnabled()) {
                this.logger.warn(this.getMessageString(entry), entry.getException());
            }
        } else if (entry.isDebug()) {
            if (this.shouldLogDebug() && this.logger.isTraceEnabled()) {
                this.logger.trace(this.getMessageString(entry));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.getMessageString(entry));
        }
    }

    protected String getMessageString(SessionLogEntry entry) {
        StringBuffer buf = new StringBuffer();
        if (this.shouldPrintSession()) {
            buf.append(this.getSessionName((Session)entry.getSession()));
            buf.append("(");
            buf.append(String.valueOf(System.identityHashCode(entry.getSession())));
            buf.append(")");
            buf.append(this.getSeparator());
        }
        if (this.shouldPrintConnection() && entry.getConnection() != null) {
            buf.append("Connection");
            buf.append("(");
            buf.append(String.valueOf(System.identityHashCode(entry.getConnection())));
            buf.append(")");
            buf.append(this.getSeparator());
        }
        buf.append(entry.getMessage());
        return buf.toString();
    }

    protected String getSessionName(Session session) {
        if (session.isUnitOfWork()) {
            return "UnitOfWork";
        }
        if (session.isServerSession()) {
            return "ServerSession";
        }
        if (session.isClientSession()) {
            return "ClientSession";
        }
        if (session.isSessionBroker()) {
            return "SessionBroker";
        }
        if (session.isRemoteSession()) {
            return "RemoteSession";
        }
        if (session.isDatabaseSession()) {
            return "DatabaseSession";
        }
        return "Session";
    }
}

