/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading;

import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.FileCopyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOverridingClassLoader
extends ClassLoader {
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final Set<String> excludedPackages = Collections.synchronizedSet(new HashSet());
    private final Set<String> excludedClasses = Collections.synchronizedSet(new HashSet());

    protected AbstractOverridingClassLoader(ClassLoader parent) {
        super(parent);
        this.excludedPackages.add("java");
    }

    public void excludePackage(String packageName) {
        Assert.notNull(packageName, "Package name must not be null");
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        this.excludedClasses.add(className);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.isEligibleForOverriding(name) && (result = this.findLoadedClass(name)) == null) {
            String internalName = name.replace('.', '/') + CLASS_FILE_SUFFIX;
            InputStream is = this.getParent().getResourceAsStream(internalName);
            if (is != null) {
                try {
                    byte[] bytes = FileCopyUtils.copyToByteArray(is);
                    byte[] transformed = this.transformIfNecessary(name, bytes);
                    result = this.defineClass(name, transformed, 0, transformed.length);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
                }
            }
        }
        if (result != null) {
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        if (this.excludedClasses.contains(className)) {
            return false;
        }
        for (String packageName : this.excludedPackages) {
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    protected abstract byte[] transformIfNecessary(String var1, byte[] var2);
}

