/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.xml;

import com.bmc.arsys.apiext.data.ARDataImporter;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.xml.ARXMLParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ARXMLImporter
extends ARDataImporter {
    public ARXMLImporter(ImportOptions importOptions) throws ARImportException {
        super(importOptions);
    }

    private void n(String string) throws ARImportException, IOException, SAXException {
        List<FormInformation> list = ((ARXMLParser)this.getParser()).extractFormInformation(string, false);
        for (FormInformation formInformation : list) {
            this.options.addFileForm(formInformation);
        }
        ((ARXMLParser)this.getParser()).parseFile(string);
    }

    @Override
    protected Parser createParser() throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        try {
            return new ARXMLParser();
        }
        catch (SAXException sAXException) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_CREATING_PARSER.toDefMsg(), sAXException), (Throwable)sAXException);
            throw new ARImportException(ImportErrors.XML_PARSE_ERROR.toDefMsg(), sAXException);
        }
    }

    @Override
    public void startImport() throws ARImportException, IOException {
        Logger logger = ThreadLocalStorage.getLogger();
        this.importStartTime = new Date();
        logger.info((Object)MessageFormat.format(ImportErrors.STARTING_IMPORT.toDefMsg(), this.options.getFileOptions().getDataFile()));
        try {
            this.n(this.options.getFileOptions().getDataFile());
        }
        catch (SAXException sAXException) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PROCESSING_FILE.toDefMsg(), sAXException), (Throwable)sAXException);
            throw new ARImportException(ImportErrors.XML_PARSE_ERROR.toDefMsg(), sAXException);
        }
    }
}

