/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import java.util.Properties;
import javax.servlet.ServletContext;

public class ServletContextPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements ServletContextAware {
    private boolean contextOverride = false;
    private boolean searchContextAttributes = false;
    private ServletContext servletContext;

    public void setContextOverride(boolean contextOverride) {
        this.contextOverride = contextOverride;
    }

    public void setSearchContextAttributes(boolean searchContextAttributes) {
        this.searchContextAttributes = searchContextAttributes;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = null;
        if (this.contextOverride && this.servletContext != null) {
            value = this.resolvePlaceholder(placeholder, this.servletContext, this.searchContextAttributes);
        }
        if (value == null) {
            value = super.resolvePlaceholder(placeholder, props);
        }
        if (value == null && this.servletContext != null) {
            value = this.resolvePlaceholder(placeholder, this.servletContext, this.searchContextAttributes);
        }
        return value;
    }

    protected String resolvePlaceholder(String placeholder, ServletContext servletContext, boolean searchContextAttributes) {
        Object attrValue;
        String value = null;
        if (searchContextAttributes && (attrValue = servletContext.getAttribute(placeholder)) != null) {
            value = attrValue.toString();
        }
        if (value == null) {
            value = servletContext.getInitParameter(placeholder);
        }
        return value;
    }
}

