/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.remoting;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.aop.support.AopUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.jms.support.JmsUtils;
import com.bmc.thirdparty.org.springframework.jms.support.destination.DestinationResolver;
import com.bmc.thirdparty.org.springframework.jms.support.destination.DynamicDestinationResolver;
import com.bmc.thirdparty.org.springframework.remoting.RemoteAccessException;
import com.bmc.thirdparty.org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocation;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationFactory;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationResult;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.Session;

public class JmsInvokerClientInterceptor
implements MethodInterceptor,
InitializingBean {
    private QueueConnectionFactory connectionFactory;
    private Object queue;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private RemoteInvocationFactory remoteInvocationFactory = new DefaultRemoteInvocationFactory();

    public void setConnectionFactory(QueueConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected QueueConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setQueue(Object queue) {
        this.queue = queue;
    }

    public void setQueueName(String queueName) {
        this.queue = queueName;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull(destinationResolver, "DestinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    public void setRemoteInvocationFactory(RemoteInvocationFactory remoteInvocationFactory) {
        this.remoteInvocationFactory = remoteInvocationFactory;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("connectionFactory is required");
        }
        if (this.queue == null) {
            throw new IllegalArgumentException("'queue' or 'queueName' is required");
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (AopUtils.isToStringMethod(methodInvocation.getMethod())) {
            return "JMS invoker proxy for queue [" + this.queue + "]";
        }
        RemoteInvocation invocation = this.createRemoteInvocation(methodInvocation);
        RemoteInvocationResult result = null;
        try {
            result = this.executeRequest(invocation);
        }
        catch (JMSException ex) {
            throw new RemoteAccessException("Cannot access JMS invoker queue [" + this.queue + "]", ex);
        }
        return this.recreateRemoteInvocationResult(result);
    }

    protected RemoteInvocation createRemoteInvocation(MethodInvocation methodInvocation) {
        return this.remoteInvocationFactory.createRemoteInvocation(methodInvocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation) throws JMSException {
        RemoteInvocationResult remoteInvocationResult;
        QueueConnection con = this.getConnectionFactory().createQueueConnection();
        QueueSession session = null;
        QueueRequestor requestor = null;
        try {
            session = con.createQueueSession(false, 1);
            Queue queueToUse = this.resolveQueue((Session)session);
            Message requestMessage = this.createRequestMessage((Session)session, invocation);
            requestor = new QueueRequestor(session, queueToUse);
            Message responseMessage = requestor.request(requestMessage);
            remoteInvocationResult = this.extractInvocationResult(responseMessage);
        }
        catch (Throwable throwable) {
            JmsUtils.closeQueueRequestor(requestor);
            JmsUtils.closeSession((Session)session);
            JmsUtils.closeConnection((Connection)con);
            throw throwable;
        }
        JmsUtils.closeQueueRequestor(requestor);
        JmsUtils.closeSession((Session)session);
        JmsUtils.closeConnection((Connection)con);
        return remoteInvocationResult;
    }

    protected Queue resolveQueue(Session session) throws JMSException {
        if (this.queue instanceof Queue) {
            return (Queue)this.queue;
        }
        if (this.queue instanceof String) {
            return this.resolveQueueName(session, (String)this.queue);
        }
        throw new IllegalStateException("Queue object [" + this.queue + "] is neither a [javax.jms.Queue] nor a queue name String");
    }

    protected Queue resolveQueueName(Session session, String queueName) throws JMSException {
        return (Queue)this.destinationResolver.resolveDestinationName(session, queueName, false);
    }

    protected Message createRequestMessage(Session session, RemoteInvocation invocation) throws JMSException {
        return session.createObjectMessage((Serializable)invocation);
    }

    protected RemoteInvocationResult extractInvocationResult(Message responseMessage) throws JMSException {
        ObjectMessage objectMessage;
        Serializable body;
        if (responseMessage instanceof ObjectMessage && (body = (objectMessage = (ObjectMessage)responseMessage).getObject()) instanceof RemoteInvocationResult) {
            return (RemoteInvocationResult)body;
        }
        return this.onInvalidResponse(responseMessage);
    }

    protected RemoteInvocationResult onInvalidResponse(Message responseMessage) throws JMSException {
        throw new MessageFormatException("Invalid response message: " + responseMessage);
    }

    protected Object recreateRemoteInvocationResult(RemoteInvocationResult result) throws Throwable {
        return result.recreate();
    }
}

