/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.support;

import com.bmc.thirdparty.org.springframework.aop.ClassFilter;
import com.bmc.thirdparty.org.springframework.aop.MethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.Pointcut;
import com.bmc.thirdparty.org.springframework.aop.support.ClassFilters;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;

class UnionPointcut
implements Pointcut,
Serializable {
    private final Pointcut a;
    private final Pointcut b;
    private MethodMatcher methodMatcher;

    public UnionPointcut(Pointcut a2, Pointcut b2) {
        Assert.notNull(a2, "First Pointcut must not be null");
        Assert.notNull(b2, "Second Pointcut must not be null");
        this.a = a2;
        this.b = b2;
        this.methodMatcher = new PointcutUnionMethodMatcher();
    }

    public ClassFilter getClassFilter() {
        return ClassFilters.union(this.a.getClassFilter(), this.b.getClassFilter());
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnionPointcut)) {
            return false;
        }
        UnionPointcut that = (UnionPointcut)other;
        return this.a.equals(that.a) && this.b.equals(that.b);
    }

    public int hashCode() {
        int code = 17;
        code = 37 * code + this.a.hashCode();
        code = 37 * code + this.b.hashCode();
        return code;
    }

    private class PointcutUnionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private PointcutUnionMethodMatcher() {
        }

        public boolean matches(Method method, Class targetClass) {
            return UnionPointcut.this.a.getClassFilter().matches(targetClass) && UnionPointcut.this.a.getMethodMatcher().matches(method, targetClass) || UnionPointcut.this.b.getClassFilter().matches(targetClass) && UnionPointcut.this.b.getMethodMatcher().matches(method, targetClass);
        }

        public boolean isRuntime() {
            return UnionPointcut.this.a.getMethodMatcher().isRuntime() || UnionPointcut.this.b.getMethodMatcher().isRuntime();
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            return UnionPointcut.this.a.getMethodMatcher().matches(method, targetClass, args) || UnionPointcut.this.b.getMethodMatcher().matches(method, targetClass, args);
        }
    }
}

