/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeanWrapper;
import com.bmc.thirdparty.org.springframework.beans.BeanWrapperImpl;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.PropertyValue;
import com.bmc.thirdparty.org.springframework.core.io.ResourceEditor;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletContextResourceLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public abstract class HttpServletBean
extends HttpServlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Set requiredProperties = new HashSet();
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init() throws ServletException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing servlet '" + this.getServletName() + "'");
        }
        try {
            ServletConfigPropertyValues pvs = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
            ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(this.getServletContext());
            bw.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = HttpServletBean.class$("com.bmc.thirdparty.org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ResourceEditor(resourceLoader));
            this.initBeanWrapper(bw);
            bw.setPropertyValues(pvs, true);
        }
        catch (BeansException ex) {
            this.logger.error("Failed to set bean properties on servlet '" + this.getServletName() + "'", ex);
            throw ex;
        }
        this.initServletBean();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Servlet '" + this.getServletName() + "' configured successfully");
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    public final String getServletName() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletName() : null;
    }

    public final ServletContext getServletContext() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletContext() : null;
    }

    protected void initServletBean() throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ServletConfigPropertyValues
    extends MutablePropertyValues {
        public ServletConfigPropertyValues(ServletConfig config, Set requiredProperties) throws ServletException {
            HashSet missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new ServletException("Initialization from ServletConfig for servlet '" + config.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, ", "));
            }
        }
    }
}

