/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa.vendor;

import com.bmc.thirdparty.org.springframework.jdbc.datasource.ConnectionHandle;
import com.bmc.thirdparty.org.springframework.jdbc.datasource.SimpleConnectionHandle;
import com.bmc.thirdparty.org.springframework.orm.jpa.DefaultJpaDialect;
import com.bmc.thirdparty.org.springframework.transaction.TransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import oracle.toplink.essentials.ejb.cmp3.EntityManager;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.sessions.UnitOfWork;

public class TopLinkJpaDialect
extends DefaultJpaDialect {
    private boolean lazyDatabaseTransaction = false;

    public void setLazyDatabaseTransaction(boolean lazyDatabaseTransaction) {
        this.lazyDatabaseTransaction = lazyDatabaseTransaction;
    }

    public Object beginTransaction(javax.persistence.EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        super.beginTransaction(entityManager, definition);
        if (!definition.isReadOnly() && !this.lazyDatabaseTransaction) {
            UnitOfWork uow = (UnitOfWork)this.getSession(entityManager);
            uow.beginEarlyTransaction();
        }
        return null;
    }

    public ConnectionHandle getJdbcConnection(javax.persistence.EntityManager em, boolean readOnly) throws PersistenceException, SQLException {
        AbstractSession session = (AbstractSession)this.getSession(em);
        Connection con = session.getAccessor().getConnection();
        return con != null ? new SimpleConnectionHandle(con) : null;
    }

    protected Session getSession(javax.persistence.EntityManager em) {
        EntityManager emi = (EntityManager)em;
        return emi.getActiveSession();
    }
}

