/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jmx.export.notification;

import com.bmc.thirdparty.org.springframework.jmx.export.notification.NotificationPublisher;
import com.bmc.thirdparty.org.springframework.jmx.export.notification.UnableToSendNotificationException;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;

public class ModelMBeanNotificationPublisher
implements NotificationPublisher {
    private final ModelMBean modelMBean;
    private final ObjectName objectName;
    private final Object managedResource;

    public ModelMBeanNotificationPublisher(ModelMBean modelMBean, ObjectName objectName, Object managedResource) {
        Assert.notNull(modelMBean, "The 'modelMBean' parameter must not be null.");
        Assert.notNull(objectName, "The 'objectName' parameter must not be null.");
        Assert.notNull(managedResource, "The 'managedResource' parameter must not be null.");
        this.modelMBean = modelMBean;
        this.objectName = objectName;
        this.managedResource = managedResource;
    }

    public void sendNotification(Notification notification) {
        Assert.notNull(notification, "Notification must not be null");
        this.replaceNotificationSourceIfNecessary(notification);
        try {
            if (notification instanceof AttributeChangeNotification) {
                this.modelMBean.sendAttributeChangeNotification((AttributeChangeNotification)notification);
            } else {
                this.modelMBean.sendNotification(notification);
            }
        }
        catch (MBeanException ex) {
            throw new UnableToSendNotificationException("Unable to send notification [" + notification + "]", ex);
        }
    }

    private void replaceNotificationSourceIfNecessary(Notification notification) {
        if (notification.getSource() == null || notification.getSource().equals(this.managedResource)) {
            notification.setSource(this.objectName);
        }
    }
}

