/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.config;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBeanNotInitializedException;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;

public abstract class AbstractFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean singleton = true;
    private boolean initialized = false;
    private Object singletonInstance;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.singleton) {
            this.initialized = true;
            this.singletonInstance = this.createInstance();
        }
    }

    public final Object getObject() throws Exception {
        if (this.singleton) {
            if (!this.initialized) {
                throw new FactoryBeanNotInitializedException();
            }
            return this.singletonInstance;
        }
        return this.createInstance();
    }

    public void destroy() throws Exception {
        if (this.singleton) {
            this.destroyInstance(this.singletonInstance);
        }
    }

    protected abstract Object createInstance() throws Exception;

    protected void destroyInstance(Object instance) throws Exception {
    }
}

