/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.digester;

import com.bmc.thirdparty.org.apache.commons.beanutils.ConvertUtils;
import com.bmc.thirdparty.org.apache.commons.beanutils.MethodUtils;
import com.bmc.thirdparty.org.apache.commons.digester.Digester;
import com.bmc.thirdparty.org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    private int targetOffset = 0;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class[] paramTypes = null;
    private String[] paramClassNames = null;
    protected boolean useExactMatch = false;
    static /* synthetic */ Class class$java$lang$String;

    public CallMethodRule(Digester digester, String methodName, int paramCount) {
        this(methodName, paramCount);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, String[] paramTypes) {
        this(methodName, paramCount, paramTypes);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, Class[] paramTypes) {
        this(methodName, paramCount, paramTypes);
    }

    public CallMethodRule(String methodName, int paramCount) {
        this(0, methodName, paramCount);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramCount == 0) {
            this.paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CallMethodRule.class$("java.lang.String")) : class$java$lang$String};
        } else {
            this.paramTypes = new Class[paramCount];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                this.paramTypes[i2] = class$java$lang$String == null ? CallMethodRule.class$("java.lang.String") : class$java$lang$String;
            }
        }
    }

    public CallMethodRule(String methodName) {
        this(0, methodName, 0, (Class[])null);
    }

    public CallMethodRule(int targetOffset, String methodName) {
        this(targetOffset, methodName, 0, (Class[])null);
    }

    public CallMethodRule(String methodName, int paramCount, String[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, String[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                this.paramTypes[i2] = "abc".getClass();
            }
        } else {
            this.paramClassNames = new String[paramTypes.length];
            for (int i3 = 0; i3 < this.paramClassNames.length; ++i3) {
                this.paramClassNames[i3] = paramTypes[i3];
            }
        }
    }

    public CallMethodRule(String methodName, int paramCount, Class[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, Class[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                this.paramTypes[i2] = "abc".getClass();
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            for (int i3 = 0; i3 < this.paramTypes.length; ++i3) {
                this.paramTypes[i3] = paramTypes[i3];
            }
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            for (int i2 = 0; i2 < this.paramClassNames.length; ++i2) {
                try {
                    this.paramTypes[i2] = digester.getClassLoader().loadClass(this.paramClassNames[i2]);
                    continue;
                }
                catch (ClassNotFoundException e2) {
                    digester.getLogger().error("(CallMethodRule) Cannot load class " + this.paramClassNames[i2], e2);
                    this.paramTypes[i2] = null;
                }
            }
        }
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] parameters = new Object[this.paramCount];
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                parameters[i2] = null;
            }
            this.digester.pushParams(parameters);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText.trim();
        }
    }

    public void end() throws Exception {
        Object[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (Object[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                int size = parameters.length;
                for (int i2 = 0; i2 < size; ++i2) {
                    this.digester.log.trace("[CallMethodRule](" + i2 + ")" + parameters[i2]);
                }
            }
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            parameters = new Object[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        for (int i3 = 0; i3 < this.paramTypes.length; ++i3) {
            paramValues[i3] = parameters[i3] == null || parameters[i3] instanceof String && !(class$java$lang$String == null ? CallMethodRule.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(this.paramTypes[i3]) ? ConvertUtils.convert((String)parameters[i3], this.paramTypes[i3]) : parameters[i3];
        }
        Object target = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call target is null (");
            sb.append("targetOffset=");
            sb.append(this.targetOffset);
            sb.append(",stackdepth=");
            sb.append(this.digester.getCount());
            sb.append(")");
            throw new SAXException(sb.toString());
        }
        if (this.digester.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call ");
            sb.append(target.getClass().getName());
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            for (int i4 = 0; i4 < paramValues.length; ++i4) {
                if (i4 > 0) {
                    sb.append(",");
                }
                if (paramValues[i4] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i4].toString());
                }
                sb.append("/");
                if (this.paramTypes[i4] == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(this.paramTypes[i4].getName());
            }
            sb.append(")");
            this.digester.log.debug(sb.toString());
        }
        Object result = null;
        result = this.useExactMatch ? MethodUtils.invokeExactMethod(target, this.methodName, paramValues, this.paramTypes) : MethodUtils.invokeMethod(target, this.methodName, paramValues, this.paramTypes);
        this.processMethodCallResult(result);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object result) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramCount=");
        sb.append(this.paramCount);
        sb.append(", paramTypes={");
        if (this.paramTypes != null) {
            for (int i2 = 0; i2 < this.paramTypes.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(this.paramTypes[i2].getName());
            }
        }
        sb.append("}");
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

