/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.session.ARRpcClientStub;
import com.bmc.arsys.apitransport.ApiProxyBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorFactory;
import com.bmc.arsys.apitransport.chunking.IARChunkReceivable;
import com.bmc.arsys.apitransport.chunking.IARChunkSendable;
import com.bmc.arsys.apitransport.chunking.IARChunkable;
import com.bmc.arsys.apitransport.connection.b;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiRpcTimeOutBase;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.apitransport.session.ArStatusInfo;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arrpc.ArBoolean;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.utils.ProcessUtil;
import java.util.concurrent.locks.ReentrantLock;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ApiProxyJRpcBase
extends ApiProxyBase {
    private static Logger case = Logger.getLogger(ApiProxyJRpcBase.class);
    protected ARRpcClientStub rpcClient = null;
    protected final ReentrantLock lock = new ReentrantLock();

    protected ApiProxyJRpcBase() {
    }

    protected ApiProxyJRpcBase(boolean bl) {
        super(bl);
    }

    protected ApiProxyJRpcBase(ApiUserContextI apiUserContextI) {
        super(apiUserContextI);
    }

    protected void initThreadLocalVariables(ApiUserContextI apiUserContextI) {
        ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(null);
        if (apiUserContextI != null) {
            ApiThreadLocalStorageBlock.getTLB().setLocaleInfo(apiUserContextI.getLocaleInfo());
            ApiThreadLocalStorageBlock.getTLB().setApiThreadInfo(null);
        }
    }

    protected void initThreadLocalInternalVariables() {
        ApiThreadLocalStorageBlock.getTLB().setInternalChunkingObj(null);
    }

    protected int getInitialXdrSize(ApiUserContextI apiUserContextI) {
        int n2 = 0;
        ARServerContext aRServerContext = ProxyManager.getARServerContext(apiUserContextI.getServer(), apiUserContextI.getPort());
        if (aRServerContext != null) {
            n2 = aRServerContext.getCurrentXDRBufferSize();
        }
        if (n2 <= 0 || n2 < 4096 || n2 > 10000000) {
            n2 = 500128;
        }
        return n2;
    }

    protected void initialization(ApiUserContextI apiUserContextI) throws ARException {
        ((b)ProxyManager.getProxyManager()).checkCleanUpTimer();
    }

    protected int connectionTry(ApiUserContextI apiUserContextI, int n2, Exception exception) throws ARException {
        if (n2 < apiUserContextI.getApiConfig().getConnectionMaxRetries()) {
            this.closeConnection();
            try {
                Thread.sleep(apiUserContextI.getApiConfig().getTimeLagBetweenRetriesMillSec());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } else {
            throw new ARException(2, 90, exception.getLocalizedMessage() + " " + apiUserContextI.getServerInfoStr());
        }
        return ++n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void arCall(ApiUserContextI apiUserContextI, int n2, ArRpcXdrIn arRpcXdrIn, ArRpcXdrOut arRpcXdrOut) throws ARException {
        boolean bl = this.isPotentialMultiThreads();
        ReentrantLock reentrantLock = null;
        try {
            if (bl) {
                reentrantLock = this.lock;
                reentrantLock.lock();
            }
            this.initThreadLocalVariables(apiUserContextI);
            this.a(apiUserContextI, n2, arRpcXdrIn, arRpcXdrOut, false);
        }
        finally {
            if (reentrantLock != null) {
                reentrantLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ApiUserContextI apiUserContextI, int n2, ArRpcXdrIn arRpcXdrIn, ArRpcXdrOut arRpcXdrOut, boolean bl) throws ARException {
        block36: {
            apiUserContextI.logApiTime("+API call, Procedure #" + n2);
            long l2 = System.currentTimeMillis();
            StringBuilder stringBuilder = case.isDebugEnabled() ? new StringBuilder() : null;
            String string = apiUserContextI.getServerInfoStr();
            boolean bl2 = false;
            if (stringBuilder != null) {
                stringBuilder.append("ProcNumber ").append(n2).append(" via ").append(this).append(" for " + string);
            }
            try {
                if (ARChunkProcessorFactory.isChunkingSupportedCall(n2)) {
                    int n3;
                    if (stringBuilder != null) {
                        stringBuilder.append(", with chunking ");
                    }
                    if ((n3 = this.a(apiUserContextI, n2, arRpcXdrIn, arRpcXdrOut)) > 0 && stringBuilder != null) {
                        stringBuilder.append(n3).append(" round call").append(n3 > 1 ? "s, " : ",");
                    }
                } else {
                    ARRpcClientStub aRRpcClientStub = (ARRpcClientStub)this.getRpcClient(apiUserContextI);
                    this.a(apiUserContextI, aRRpcClientStub);
                    aRRpcClientStub.arCall(n2, arRpcXdrIn, arRpcXdrOut);
                }
                bl2 = true;
            }
            catch (OncRpcException oncRpcException) {
                if (ARChunkProcessorFactory.isChunkingSupportedCall(n2) && oncRpcException.getReason() == 4 && !this.a(n2)) {
                    bl = false;
                }
                if (stringBuilder != null) {
                    String string2 = stringBuilder.toString() + " received OncRpcException: " + oncRpcException.getLocalizedMessage();
                    case.debug(string2);
                }
                if (!bl) {
                    boolean bl3 = true;
                    boolean bl4 = false;
                    if (oncRpcException.getReason() == 7 && oncRpcException instanceof OncRpcAuthenticationException) {
                        switch (((OncRpcAuthenticationException)oncRpcException).getAuthStatus()) {
                            case 2: {
                                bl3 = false;
                                bl4 = true;
                                break;
                            }
                            case 1: {
                                this.getRpcClient(apiUserContextI).enableAPICallEncryption(false);
                                bl3 = false;
                                break;
                            }
                            case 5: {
                                this.getRpcClient(apiUserContextI).enableAPICallEncryption(true);
                                bl3 = false;
                                break;
                            }
                        }
                    } else if (oncRpcException.getReason() == 11 || oncRpcException.getReason() == 2 || oncRpcException.getReason() == 1 || oncRpcException.getReason() == 10 || oncRpcException.getReason() == 5 || this.isArException(oncRpcException)) {
                        this.resetChunkProcessor();
                        this.closeConnection(apiUserContextI);
                        throw this.convertException(oncRpcException, n2, apiUserContextI);
                    }
                    if (bl4) {
                        try {
                            this.getRpcClient(apiUserContextI).handShake(string, false, 0, 0);
                        }
                        catch (Exception exception) {
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        if (stringBuilder != null) {
                            stringBuilder.append(" connection ").append(this).append(" to ").append(string).append(" re-established w reason : ").append(oncRpcException.getLocalizedMessage());
                            case.debug(stringBuilder.toString());
                        }
                        this.closeConnection(apiUserContextI);
                    }
                    stringBuilder = null;
                    this.a(apiUserContextI, n2, arRpcXdrIn, arRpcXdrOut, true);
                    break block36;
                }
                this.resetChunkProcessor();
                this.closeConnection(apiUserContextI);
                throw this.convertException(oncRpcException, n2, apiUserContextI);
            }
            finally {
                this.updateUserContext(apiUserContextI, arRpcXdrOut);
                try {
                    this.verifyStatus(apiUserContextI, arRpcXdrOut, bl2, stringBuilder);
                }
                finally {
                    apiUserContextI.logApiTime("-API call, Procedure #" + n2);
                    if (stringBuilder != null) {
                        if (bl2 && !arRpcXdrOut.getStatus().hasError()) {
                            stringBuilder.append(" succeed. -API arcall");
                        } else {
                            stringBuilder.append(" returned error. -API arcall");
                        }
                        ProcessUtil.getInstance().PrintProcessTime(l2, stringBuilder.toString());
                        case.debug(stringBuilder.toString());
                    }
                }
            }
        }
    }

    private boolean a(int n2) {
        IARChunkSendable iARChunkSendable = null;
        if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(n2)) {
            iARChunkSendable = (IARChunkSendable)ApiThreadLocalStorageBlock.getTLB().getChunkProcessor();
        }
        if (iARChunkSendable == null) {
            return true;
        }
        return iARChunkSendable.getRetryValue() >= 2;
    }

    private void a(ApiUserContextI apiUserContextI, ARRpcClientStub aRRpcClientStub) throws ARException {
        ArRpcCallContext arRpcCallContext = aRRpcClientStub.getArRpcCallContext();
        for (int n2 : apiUserContextI.getUserSession().keySet()) {
            arRpcCallContext.setSessionVariable(n2, apiUserContextI.getUserSession().get(n2));
        }
    }

    protected boolean isArException(OncRpcException oncRpcException) {
        return oncRpcException.getReason() == 16 && oncRpcException.getCause() instanceof AREncryptionException;
    }

    protected IARChunkable getChunkProcessor(ApiUserContextI apiUserContextI, int n2) throws ARException {
        if (ApiThreadLocalStorageBlock.getTLB().getChunkProcessor() == null) {
            IARChunkable iARChunkable = ARChunkProcessorFactory.createProcessor(n2);
            iARChunkable.init(this.getInternalObj(apiUserContextI));
            ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(iARChunkable);
        }
        return ApiThreadLocalStorageBlock.getTLB().getChunkProcessor();
    }

    protected void resetChunkProcessor() {
        ApiThreadLocalStorageBlock.getTLB().resetChunkingProcessor();
    }

    private int a(ApiUserContextI apiUserContextI, int n2, ArRpcXdrIn arRpcXdrIn, ArRpcXdrOut arRpcXdrOut) throws ARException, OncRpcException {
        ArRpcControlStruct arRpcControlStruct = arRpcXdrIn.getControl();
        ArStatusInfo arStatusInfo = new ArStatusInfo();
        IARChunkable iARChunkable = this.getChunkProcessor(apiUserContextI, n2);
        int n3 = this.getArRpcCallContext(apiUserContextI).getSessionVariable(1).getIntValue();
        ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(iARChunkable);
        int n4 = iARChunkable.getRoundNumber();
        try {
            while (iARChunkable.hasNextRound()) {
                iARChunkable.nextRound();
                n4 = iARChunkable.getRoundNumber();
                case.debug("arChunkingCall: Processor=" + iARChunkable + ", Proc Number=" + n2 + ", Round Number=" + n4 + " via " + this);
                if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(n2)) {
                    ((IARChunkSendable)iARChunkable).loadOneChunkToParamIn(n3, arRpcXdrIn);
                }
                ARRpcClientStub aRRpcClientStub = (ARRpcClientStub)this.getRpcClient(apiUserContextI);
                this.a(apiUserContextI, aRRpcClientStub);
                aRRpcClientStub.arCall(n2, arRpcXdrIn, arRpcXdrOut);
                if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(n2)) {
                    ((IARChunkSendable)iARChunkable).resetChunkRetry();
                }
                arStatusInfo.add(arRpcXdrOut.getStatus());
                if (arRpcXdrOut.getStatus().hasError()) break;
                if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(n2)) {
                    ((IARChunkSendable)iARChunkable).resetChunkRetry();
                    case.debug("arChunkingCall: resetting chunk retry counter");
                }
                if (ARChunkProcessorFactory.isReceiveChunkingOnOutputParamCall(n2)) {
                    ((IARChunkReceivable)iARChunkable).retrieveChunkingData(arRpcXdrOut);
                }
                arRpcControlStruct.setCacheId(arRpcXdrOut.getControl().getCacheId());
                arRpcControlStruct.setRequestId(arRpcXdrOut.getControl().getRequestId());
            }
            if (ARChunkProcessorFactory.isReceiveChunkingOnOutputParamCall(n2)) {
                ((IARChunkReceivable)iARChunkable).postProcess(arRpcXdrOut);
                case.debug("arChunkingCall: Done with postProcess via " + this);
            }
            this.resetChunkProcessor();
        }
        catch (OncRpcException oncRpcException) {
            iARChunkable.setRoundNumber(--n4);
            ApiThreadLocalStorageBlock.getTLB().setChunkProcessor(iARChunkable);
            ArRpcControlStruct arRpcControlStruct2 = arRpcXdrIn.getControl();
            ArBoolean arBoolean = null;
            arBoolean = !iARChunkable.hasNextRound() ? new ArBoolean(1) : new ArBoolean(0);
            arRpcControlStruct2.setDone(arBoolean);
            if (ARChunkProcessorFactory.isSendChunkingOnInputParamCall(n2)) {
                ((IARChunkSendable)iARChunkable).nextChunkRetry();
                case.debug("arChunkingCall: incrementing chunk retry counter " + ((IARChunkSendable)iARChunkable).getRetryValue());
            }
            throw oncRpcException;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws ARException {
        block8: {
            boolean bl = this.isPotentialMultiThreads();
            ReentrantLock reentrantLock = null;
            try {
                if (bl) {
                    reentrantLock = this.lock;
                    reentrantLock.lock();
                }
                if (this.rpcClient == null) break block8;
                try {
                    if (case.isTraceEnabled()) {
                        case.trace("connection " + this + " closed.");
                    }
                    this.rpcClient.close();
                    this.rpcClient = null;
                }
                catch (OncRpcException oncRpcException) {
                    throw this.convertException(oncRpcException);
                }
            }
            finally {
                if (reentrantLock != null) {
                    reentrantLock.unlock();
                }
            }
        }
    }

    protected void closeConnection(ApiUserContextI apiUserContextI) throws ARException {
        this.closeConnection();
    }

    protected void updateUserContext(ApiUserContextI apiUserContextI, ArRpcXdrOut arRpcXdrOut) {
        if (arRpcXdrOut == null || apiUserContextI == null) {
            return;
        }
        ArRpcControlStruct arRpcControlStruct = arRpcXdrOut.getControl();
        if (arRpcControlStruct != null) {
            if (apiUserContextI.getImpersonatedUser() != null && apiUserContextI.getImpersonatedUser().length() != 0) {
                apiUserContextI.setImpersonatedCacheId(arRpcControlStruct.getCacheId());
            } else {
                apiUserContextI.setCacheId(arRpcControlStruct.getCacheId());
            }
            ArTimestamp arTimestamp = arRpcControlStruct.getOperationTime();
            if (arTimestamp != null) {
                apiUserContextI.setOperationTime(new Timestamp(arTimestamp.value));
            }
            if (apiUserContextI.getOverridePrevIP()) {
                apiUserContextI.setOverridePrevIP(false);
            }
        }
    }

    protected void verifyStatus(ApiUserContextI apiUserContextI, ArRpcXdrOut arRpcXdrOut, boolean bl, StringBuilder stringBuilder) throws ARException {
        if (apiUserContextI == null || arRpcXdrOut == null || arRpcXdrOut.getStatus() == null) {
            return;
        }
        ArStatusInfo arStatusInfo = new ArStatusInfo(arRpcXdrOut.getStatus());
        apiUserContextI.setLastStatus(arStatusInfo);
        apiUserContextI.setMultiLastStatus(null);
        if (arRpcXdrOut.getStatus().hasError()) {
            if (case.isDebugEnabled()) {
                if (stringBuilder != null) {
                    case.debug(stringBuilder.toString() + (bl ? " succeed. " : " faled. ") + " And AR Server returns error: ");
                }
                case.debug(arStatusInfo);
            }
            throw new ARException(new ArStatusInfo(arRpcXdrOut.getStatus()));
        }
    }

    protected void verifyStatus(ApiUserContextI apiUserContextI, ArRpcXdrOut arRpcXdrOut) throws ARException {
        this.verifyStatus(apiUserContextI, arRpcXdrOut, true, null);
    }

    protected ARException convertException(OncRpcException oncRpcException) {
        return this.a(oncRpcException, 0);
    }

    private ARException a(OncRpcException oncRpcException, int n2) {
        return this.convertException(oncRpcException, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ARException convertException(OncRpcException oncRpcException, int n2, ApiUserContextI apiUserContextI) {
        String string;
        ARException aRException = null;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string = apiUserContextI != null ? apiUserContextI.getServerInfoStr() : "(no context)";
        if (this.isArException(oncRpcException)) {
            aRException = new ARException(2, ((AREncryptionException)oncRpcException.getCause()).getErrorNum(), string + " " + ((AREncryptionException)oncRpcException.getCause()).getMessage());
        } else if (oncRpcException.getReason() == 5 && n2 > 0 && apiUserContextI != null) {
            aRException = new ARException(2, this.a(apiUserContextI, n2), string + " " + oncRpcException.getLocalizedMessage());
        } else if (oncRpcException.getReason() == 10) {
            aRException = new ARException(2, 341, string + " " + oncRpcException.getLocalizedMessage());
        } else {
            try {
                stringBuilder.append("ProcNumber ").append(n2).append(" via ").append(this).append(" for " + string).append(", converts OncRpcException");
                stringBuilder.append(" to ARError ");
                stringBuilder.append(91);
                case.error(stringBuilder, oncRpcException);
            }
            finally {
                aRException = new ARException(2, 91, string + " " + oncRpcException.getLocalizedMessage());
            }
        }
        return aRException;
    }

    protected String getServerCharSetName(ApiUserContextI apiUserContextI) throws ARException {
        return this.getArRpcCallContext(apiUserContextI).getServerCharSetName();
    }

    protected Object getInternalObj(ApiUserContextI apiUserContextI) throws ARException {
        return ApiThreadLocalStorageBlock.getTLB().getInternalChunkingObj();
    }

    protected void setInternalObj(ApiUserContextI apiUserContextI, Object object) throws ARException {
        ApiThreadLocalStorageBlock.getTLB().setInternalChunkingObj(object);
    }

    protected void cleanUpTL() {
        if (ApiThreadLocalStorageBlock.isTLBExist()) {
            ApiThreadLocalStorageBlock.getTLB().cleanUp();
        }
    }

    protected ArRpcCallContext getArRpcCallContext(ApiUserContextI apiUserContextI) throws ARException {
        return this.getRpcClient(apiUserContextI).getArRpcCallContext();
    }

    @Override
    protected String ARInitApiSourceGuid(ApiUserContextI apiUserContextI) throws ARException {
        return null;
    }

    private int a(ApiUserContextI apiUserContextI, int n2) {
        return ((ApiRpcTimeOutBase)apiUserContextI.getApiPropertyManager().get("AR_PROPERTY_RPC_TIMEOUT")).getErrorCode(n2);
    }

    protected boolean isPotentialMultiThreads() {
        return !ProxyManager.isUseConnectionPooling();
    }
}

