/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.common.BackupRollingFileAppender;
import com.bmc.arsys.common.OSNameUtil;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;

public class LoggerFactory {
    private boolean configFlag = false;
    private static final String configFileName = "log4j.properties";
    private static final String pattern = "%d [%t] %-5p %c %x - %m%n";
    private static boolean isWindows;
    private static final String dot_seperator = ".";

    public LoggerFactory() {
    }

    public LoggerFactory(boolean bl) {
        this.configFlag = bl;
        if (this.configFlag) {
            PropertyConfigurator.configure((String)configFileName);
        }
    }

    public Logger createLogger(String string, String string2, String string3, Level level) throws Exception {
        return this.createLogger(string, string2, string3, level, true, 0L, 0);
    }

    public Logger createLogger(String string, String string2, String string3, Level level, boolean bl, long l, int n) throws Exception {
        String string4 = string2;
        if (string == null) {
            return null;
        }
        if (string3 != null) {
            string4 = string4.contains(dot_seperator) ? string4.substring(0, string4.lastIndexOf(dot_seperator) + 1) + this.replaceSpecialChars(string3) + dot_seperator + string4.substring(string4.lastIndexOf(dot_seperator) + 1) : string4 + dot_seperator + this.replaceSpecialChars(string3);
        }
        return this.createLogger(string, string4, level, bl, l, n);
    }

    public Logger createLogger(String string, String string2, Level level) throws Exception {
        return this.createLogger(string, string2, level, true, 0L, 0);
    }

    public Logger createLogger(String string, String string2, Level level, boolean bl, long l, int n) throws Exception {
        return this.createLogger(string, string2, level, (Layout)new PatternLayout(pattern), bl, l, n);
    }

    public Logger createLogger(String string, String string2, Level level, Layout layout) throws Exception {
        return this.createLogger(string, string2, level, true, 0L, 0);
    }

    public Logger createLogger(String string, String string2, Level level, Layout layout, boolean bl, long l, int n) throws Exception {
        return this.createLogger(string, string2, level, layout, bl, l, n, false);
    }

    public Logger createLogger(String string, String string2, Level level, Layout layout, boolean bl, long l, int n, boolean bl2) throws Exception {
        if (string == null) {
            return null;
        }
        if (layout == null) {
            layout = new PatternLayout(pattern);
        }
        Logger logger = Logger.getLogger((String)string);
        try {
            if (!this.configFlag) {
                logger.setAdditivity(false);
                BackupRollingFileAppender backupRollingFileAppender = new BackupRollingFileAppender(bl2);
                backupRollingFileAppender.setLayout(layout);
                backupRollingFileAppender.setFile(string2);
                if (l > 0L) {
                    backupRollingFileAppender.setMaximumFileSize(l);
                }
                if (n > 0) {
                    backupRollingFileAppender.setMaxBackupIndex(n);
                }
                if (bl) {
                    backupRollingFileAppender.activateOptions();
                }
                logger.addAppender((Appender)backupRollingFileAppender);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        logger.setLevel(level);
        return logger;
    }

    public String replaceSpecialChars(String string) {
        if (isWindows && string != null) {
            return string.replaceAll("[\\\\/:*?\"<>|]", dot_seperator);
        }
        return string;
    }

    public void enableLogging(Logger logger) {
        Enumeration enumeration = logger.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof FileAppender)) continue;
                ((FileAppender)e).activateOptions();
            }
        }
    }

    public Logger createErrorLogger(String string, String string2, String string3) throws IOException {
        Logger logger = Logger.getLogger((String)string);
        logger.setAdditivity(false);
        if (string3 == null) {
            string3 = pattern;
        }
        PatternLayout patternLayout = new PatternLayout(string3);
        FileAppender fileAppender = new FileAppender((Layout)patternLayout, string2);
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(Level.ERROR);
        return logger;
    }

    public void setRolloverProperties(Logger logger, long l, int n) {
        Enumeration enumeration = logger.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof RollingFileAppender)) continue;
                RollingFileAppender rollingFileAppender = (RollingFileAppender)e;
                rollingFileAppender.setMaximumFileSize(l);
                rollingFileAppender.setMaxBackupIndex(n);
            }
        }
    }

    public String appendPoolNameSuffix(String string, String string2) {
        if (string2 != null) {
            string = string.contains(dot_seperator) ? string.substring(0, string.lastIndexOf(dot_seperator) + 1) + this.replaceSpecialChars(string2) + dot_seperator + string.substring(string.lastIndexOf(dot_seperator) + 1) : string + dot_seperator + this.replaceSpecialChars(string2);
        }
        return string;
    }

    public void setNewLogFile(Logger logger, String string, boolean bl) {
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            ((FileAppender)appender).setFile(string);
            if (!bl) continue;
            ((FileAppender)appender).activateOptions();
        }
    }

    static {
        if (OSNameUtil.getIsWindows()) {
            isWindows = true;
        }
    }
}

