/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrVoid;

public class OncRpcPortmapClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;
    protected OncRpcClient portmapClient;

    public OncRpcPortmapClient(InetAddress host) throws OncRpcException, IOException {
        this(host, 17, 0);
    }

    public OncRpcPortmapClient(InetAddress host, int protocol) throws OncRpcException, IOException {
        this(host, protocol, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OncRpcPortmapClient(InetAddress host, int protocol, int timeout) throws OncRpcException, IOException {
        int pmap_ver = 2;
        String tcpVerStr = "";
        if (host instanceof Inet6Address) {
            pmap_ver = 4;
            tcpVerStr = "6";
        }
        int curVersion = pmap_ver;
        int stopVersion = ArRpcBindHelper.getRpcBindTryStopVersion(pmap_ver);
        block4 : switch (protocol) {
            case 17: {
                while (curVersion >= stopVersion) {
                    if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                        System.out.println("creating rpcbind udp" + tcpVerStr + " client v" + curVersion + ", the fall back rpcbind will be ver:" + stopVersion);
                    }
                    boolean rpcbindClientCreated = false;
                    try {
                        this.portmapClient = new OncRpcUdpClient(host, 100000, curVersion, 111);
                        rpcbindClientCreated = true;
                        if (!ArRpcBindHelper.rpcbind_client_debug.booleanValue()) continue;
                        System.out.println("created rpcbind udp" + tcpVerStr + " client v" + curVersion);
                    }
                    catch (OncRpcException e2) {
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind udp" + tcpVerStr + " client v" + curVersion + " failed ");
                        }
                        if (curVersion != stopVersion) continue;
                        throw e2;
                    }
                    finally {
                        if (rpcbindClientCreated) break block4;
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind udp" + tcpVerStr + " client v" + curVersion + " failed ");
                        }
                        --curVersion;
                    }
                }
                break;
            }
            case 6: {
                while (curVersion >= stopVersion) {
                    if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                        System.out.println("creating rpcbind tcp" + tcpVerStr + " client v" + curVersion + ", the fall back rpcbind will be ver:" + stopVersion);
                    }
                    boolean rpcbindClientCreated = false;
                    try {
                        this.portmapClient = new OncRpcTcpClient(host, 100000, curVersion, 111, 0, timeout);
                        rpcbindClientCreated = true;
                        if (!ArRpcBindHelper.rpcbind_client_debug.booleanValue()) break block4;
                        System.out.println("created rpcbind tcp" + tcpVerStr + " client v" + curVersion);
                        break block4;
                    }
                    catch (OncRpcException e3) {
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind tcp" + tcpVerStr + " client v" + curVersion + " failed ");
                        }
                        if (curVersion != stopVersion) continue;
                        throw e3;
                    }
                    finally {
                        if (rpcbindClientCreated) break block4;
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind tcp" + tcpVerStr + " client v" + curVersion + " failed ");
                        }
                        --curVersion;
                    }
                }
                break;
            }
            default: {
                throw new OncRpcException(17);
            }
        }
    }

    public void close() throws OncRpcException {
        this.portmapClient.close();
    }

    public OncRpcClient getOncRpcClient() {
        return this.portmapClient;
    }

    public int getPort(int program, int version, int protocol) throws OncRpcException {
        XdrAble params = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 3, program, version, protocol, 0);
        XdrAble result = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 3, false);
        try {
            this.portmapClient.call(3, params, result);
        }
        catch (OncRpcException e2) {
            throw new OncRpcException(14);
        }
        int port = 0;
        if (this.portmapClient.host instanceof Inet6Address) {
            String rtnStr = ((XdrString)result).stringValue();
            if (rtnStr != null && rtnStr.length() > 0) {
                port = ArRpcBindHelper.getPort(rtnStr);
            }
        } else {
            port = ((OncRpcGetPortResult)result).port;
        }
        if (port == 0) {
            if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                System.out.println("rpcbind getPort did not get port back ");
            }
            throw new OncRpcProgramNotRegisteredException();
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind getPort = " + port);
        }
        return port;
    }

    public boolean setPort(int program, int version, int protocol, int port) throws OncRpcException {
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind setPort ... " + port);
        }
        XdrAble params = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 1, program, version, protocol, port);
        XdrAble result = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 1, false);
        try {
            this.portmapClient.call(1, params, result);
        }
        catch (OncRpcException e2) {
            throw new OncRpcException(14);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind setPort returns boolean: " + ((XdrBoolean)result).booleanValue());
        }
        return ((XdrBoolean)result).booleanValue();
    }

    public boolean unsetPort(int program, int version) throws OncRpcException {
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind unsetPort ... ");
        }
        XdrAble params = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 2, program, version, 0, 0);
        XdrAble result = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 2, false);
        try {
            this.portmapClient.call(2, params, result);
        }
        catch (OncRpcException e2) {
            throw new OncRpcException(14);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind unsetPort returns boolean: " + ((XdrBoolean)result).booleanValue());
        }
        return ((XdrBoolean)result).booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult result = new OncRpcDumpResult();
        try {
            this.portmapClient.call(4, XdrVoid.XDR_VOID, result);
        }
        catch (OncRpcException e2) {
            throw new OncRpcException(14);
        }
        Object[] info = new OncRpcServerIdent[result.servers.size()];
        result.servers.copyInto(info);
        return info;
    }

    public void ping() throws OncRpcException {
        try {
            this.portmapClient.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
        }
        catch (OncRpcException e2) {
            throw new OncRpcException(14);
        }
    }
}

