/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.interceptor;

import com.bmc.thirdparty.org.springframework.transaction.interceptor.TransactionAttribute;
import com.bmc.thirdparty.org.springframework.transaction.interceptor.TransactionAttributeSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;

public class CompositeTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    private final TransactionAttributeSource[] transactionAttributeSources;

    public CompositeTransactionAttributeSource(TransactionAttributeSource[] transactionAttributeSources) {
        Assert.notNull(transactionAttributeSources, "TransactionAttributeSource array must not be null");
        this.transactionAttributeSources = transactionAttributeSources;
    }

    public final TransactionAttributeSource[] getTransactionAttributeSources() {
        return this.transactionAttributeSources;
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        for (int i2 = 0; i2 < this.transactionAttributeSources.length; ++i2) {
            TransactionAttributeSource tas = this.transactionAttributeSources[i2];
            TransactionAttribute ta = tas.getTransactionAttribute(method, targetClass);
            if (ta == null) continue;
            return ta;
        }
        return null;
    }
}

