/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.hibernate3.annotation;

import com.bmc.thirdparty.org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.hibernate.HibernateException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;

public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean {
    private Class[] annotatedClasses;
    private String[] annotatedPackages;

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass(AnnotationConfiguration.class);
    }

    public void setConfigurationClass(Class configurationClass) {
        if (configurationClass == null || !AnnotationConfiguration.class.isAssignableFrom(configurationClass)) {
            throw new IllegalArgumentException("AnnotationSessionFactoryBean only supports AnnotationConfiguration or subclasses");
        }
        super.setConfigurationClass(configurationClass);
    }

    public void setAnnotatedClasses(Class[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setAnnotatedPackages(String[] annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    protected final void postProcessConfiguration(Configuration config) throws HibernateException {
        int i2;
        AnnotationConfiguration annConfig = (AnnotationConfiguration)config;
        if (this.annotatedClasses != null) {
            for (i2 = 0; i2 < this.annotatedClasses.length; ++i2) {
                annConfig.addAnnotatedClass(this.annotatedClasses[i2]);
            }
        }
        if (this.annotatedPackages != null) {
            for (i2 = 0; i2 < this.annotatedPackages.length; ++i2) {
                annConfig.addPackage(this.annotatedPackages[i2]);
            }
        }
        this.postProcessAnnotationConfiguration(annConfig);
    }

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration config) throws HibernateException {
    }
}

