/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.aspectj.annotation;

import com.bmc.thirdparty.org.aopalliance.aop.Advice;
import com.bmc.thirdparty.org.springframework.aop.Pointcut;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJExpressionPointcut;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJPrecedenceInformation;
import com.bmc.thirdparty.org.springframework.aop.aspectj.InstantiationModelAwarePointcutAdvisor;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AspectMetadata;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import com.bmc.thirdparty.org.springframework.aop.support.DynamicMethodMatcherPointcut;
import com.bmc.thirdparty.org.springframework.aop.support.Pointcuts;
import com.bmc.thirdparty.org.springframework.core.Ordered;
import java.lang.reflect.Method;
import org.aspectj.lang.reflect.PerClauseKind;

class InstantiationModelAwarePointcutAdvisorImpl
implements InstantiationModelAwarePointcutAdvisor,
Ordered,
AspectJPrecedenceInformation {
    private final AspectJExpressionPointcut declaredPointcut;
    private Pointcut pointcut;
    private final MetadataAwareAspectInstanceFactory aif;
    private final Method method;
    private final boolean lazy;
    private final AspectJAdvisorFactory atAspectJAdvisorFactory;
    private Advice instantiatedAdvice;
    private int declarationOrder;
    private String aspectName;
    private int aspectOrder = Integer.MAX_VALUE;
    private Boolean isBeforeAdvice = null;
    private Boolean isAfterAdvice = null;

    public InstantiationModelAwarePointcutAdvisorImpl(AspectJAdvisorFactory af, AspectJExpressionPointcut ajexp, MetadataAwareAspectInstanceFactory aif, Method method, int declarationOrderInAspect, String aspectName) {
        this.declaredPointcut = ajexp;
        this.method = method;
        this.atAspectJAdvisorFactory = af;
        this.aif = aif;
        this.declarationOrder = declarationOrderInAspect;
        this.aspectName = aspectName;
        if (aif.getAspectMetadata().isLazilyInstantiated()) {
            Pointcut preInstantiationORPointcut = Pointcuts.union(aif.getAspectMetadata().getPerClausePointcut(), this.declaredPointcut);
            this.pointcut = new PerTargetInstantiationModelPointcut(this.declaredPointcut, preInstantiationORPointcut, aif);
            this.lazy = true;
        } else {
            this.instantiatedAdvice = this.instantiateAdvice(this.declaredPointcut);
            this.pointcut = this.declaredPointcut;
            this.lazy = false;
        }
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public boolean isPerInstance() {
        return this.getAspectMetadata().getAjType().getPerClause().getKind() != PerClauseKind.SINGLETON;
    }

    public AspectMetadata getAspectMetadata() {
        return this.aif.getAspectMetadata();
    }

    public synchronized Advice getAdvice() {
        if (this.instantiatedAdvice == null) {
            this.instantiatedAdvice = this.instantiateAdvice(this.declaredPointcut);
        }
        return this.instantiatedAdvice;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public synchronized boolean isAdviceInstantiated() {
        return this.instantiatedAdvice != null;
    }

    private Advice instantiateAdvice(AspectJExpressionPointcut pcut) {
        return this.atAspectJAdvisorFactory.getAdvice(this.method, pcut, this.aif, this.declarationOrder, this.aspectName);
    }

    public MetadataAwareAspectInstanceFactory getAspectInstanceFactory() {
        return this.aif;
    }

    public AspectJExpressionPointcut getDeclaredPointcut() {
        return this.declaredPointcut;
    }

    public String toString() {
        return "InstantiationModelAwarePointcutAdvisor: expr='" + this.getDeclaredPointcut().getExpression() + "' advice method=" + this.method + "; perClauseKind=" + this.aif.getAspectMetadata().getAjType().getPerClause().getKind() + "; instantiationCount=" + this.aif.getInstantiationCount();
    }

    public void setOrder(int order) {
        this.aspectOrder = order;
    }

    public int getOrder() {
        return this.aspectOrder;
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public int getDeclarationOrder() {
        return this.declarationOrder;
    }

    public boolean isBeforeAdvice() {
        if (this.isBeforeAdvice == null) {
            this.determineAdviceType();
        }
        return this.isBeforeAdvice;
    }

    public boolean isAfterAdvice() {
        if (this.isAfterAdvice == null) {
            this.determineAdviceType();
        }
        return this.isAfterAdvice;
    }

    private void determineAdviceType() {
        Class<?> candidateAspectClass = this.aif.getAspectMetadata().getAspectClass();
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(this.method);
        if (aspectJAnnotation == null) {
            this.isBeforeAdvice = false;
            this.isAfterAdvice = false;
        } else {
            switch (aspectJAnnotation.getAnnotationType()) {
                case AtAfter: 
                case AtAfterReturning: 
                case AtAfterThrowing: {
                    this.isAfterAdvice = true;
                    this.isBeforeAdvice = false;
                    break;
                }
                case AtAround: 
                case AtPointcut: {
                    this.isAfterAdvice = false;
                    this.isBeforeAdvice = false;
                    break;
                }
                case AtBefore: {
                    this.isAfterAdvice = false;
                    this.isBeforeAdvice = true;
                }
            }
        }
    }

    private class PerTargetInstantiationModelPointcut
    extends DynamicMethodMatcherPointcut {
        private final AspectJExpressionPointcut declaredPointcut;
        private final Pointcut preInstantiationORPointcut;
        private final MetadataAwareAspectInstanceFactory aif;

        private PerTargetInstantiationModelPointcut(AspectJExpressionPointcut declaredPointcut, Pointcut preInstantiationORPointcut, MetadataAwareAspectInstanceFactory aif) {
            this.declaredPointcut = declaredPointcut;
            this.preInstantiationORPointcut = preInstantiationORPointcut;
            this.aif = aif;
        }

        public boolean matches(Method method, Class targetClass) {
            return this.aif.getInstantiationCount() > 0 && this.declaredPointcut.matches(method, targetClass) || this.preInstantiationORPointcut.getMethodMatcher().matches(method, targetClass);
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            return this.aif.getInstantiationCount() > 0 && this.declaredPointcut.matches(method, targetClass);
        }
    }
}

