/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;

public class ArRpcBindInet6
implements XdrAble,
Serializable {
    public int r_prog;
    public int r_vers;
    public String r_netid = "";
    public String r_addr = "";
    public String r_owner = "";
    private static final long serialVersionUID = -6561376848099201857L;

    public void setR_prog(int x) {
        this.r_prog = x;
    }

    public int getR_prog() {
        return this.r_prog;
    }

    public void setR_vers(int x) {
        this.r_vers = x;
    }

    public int getR_vers() {
        return this.r_vers;
    }

    public void setR_netid(String x) {
        this.r_netid = x;
    }

    public String getR_netid() {
        return this.r_netid;
    }

    public void setR_addr(String x) {
        this.r_addr = x;
    }

    public String getR_addr() {
        return this.r_addr;
    }

    public void setR_owner(String x) {
        this.r_owner = x;
    }

    public String getR_owner() {
        return this.r_owner;
    }

    public ArRpcBindInet6(InetAddress host, int prog, int ver, int protocol, int port) {
        StringBuilder sb = new StringBuilder();
        String ip = "::.";
        sb.append(ip).append(Integer.toString(port >> 8 & 0xFF)).append(".").append(Integer.toString(port & 0xFF));
        this.r_addr = sb.toString();
        this.r_netid = protocol == 17 ? ArRpcBindHelper.udp6_netid : ArRpcBindHelper.tcp6_netid;
        this.r_owner = ArRpcBindHelper.owner;
        this.r_prog = prog;
        this.r_vers = ver;
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            String logStrPrefix = "RPCBind_" + this.r_netid + "_";
            System.out.println(logStrPrefix + "addr: " + this.r_addr);
            System.out.println(logStrPrefix + "netid: " + this.r_netid);
            System.out.println(logStrPrefix + "owner: " + this.r_owner);
            System.out.println(logStrPrefix + "prog: " + this.r_prog);
            System.out.println(logStrPrefix + "vers: " + this.r_vers);
        }
    }

    public ArRpcBindInet6(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.xdrDecode(xdr);
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeInt(this.r_prog);
        xdr.xdrEncodeInt(this.r_vers);
        xdr.xdrEncodeString(this.r_netid);
        xdr.xdrEncodeString(this.r_addr);
        xdr.xdrEncodeString(this.r_owner);
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.r_prog = xdr.xdrDecodeInt();
        this.r_vers = xdr.xdrDecodeInt();
        this.r_netid = xdr.xdrDecodeString();
        this.r_addr = xdr.xdrDecodeString();
        this.r_owner = xdr.xdrDecodeString();
    }
}

