/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jmx.export.naming;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.support.PropertiesLoaderUtils;
import com.bmc.thirdparty.org.springframework.jmx.export.naming.ObjectNamingStrategy;
import com.bmc.thirdparty.org.springframework.jmx.support.ObjectNameManager;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import java.io.IOException;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class KeyNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties mappings;
    private Resource[] mappingLocations;
    private Properties mergedMappings;

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void setMappingLocation(Resource location) {
        this.mappingLocations = new Resource[]{location};
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void afterPropertiesSet() throws IOException {
        this.mergedMappings = new Properties();
        CollectionUtils.mergePropertiesIntoMap(this.mappings, this.mergedMappings);
        if (this.mappingLocations != null) {
            for (int i2 = 0; i2 < this.mappingLocations.length; ++i2) {
                Resource location = this.mappingLocations[i2];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Loading JMX object name mappings file from " + location);
                }
                PropertiesLoaderUtils.fillProperties(this.mergedMappings, location);
            }
        }
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        String objectName = null;
        if (this.mergedMappings != null) {
            objectName = this.mergedMappings.getProperty(beanKey);
        }
        if (objectName == null) {
            objectName = beanKey;
        }
        return ObjectNameManager.getInstance(objectName);
    }
}

