/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.support.destination;

import com.bmc.thirdparty.org.springframework.jms.support.destination.DestinationResolver;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;

public class DynamicDestinationResolver
implements DestinationResolver {
    public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        Assert.notNull(session, "Session must not be null");
        Assert.notNull(destinationName, "Destination name must not be null");
        if (pubSubDomain) {
            return this.resolveTopic(session, destinationName);
        }
        return this.resolveQueue(session, destinationName);
    }

    protected Topic resolveTopic(Session session, String topicName) throws JMSException {
        if (session instanceof TopicSession) {
            return ((TopicSession)session).createTopic(topicName);
        }
        return session.createTopic(topicName);
    }

    protected Queue resolveQueue(Session session, String queueName) throws JMSException {
        if (session instanceof QueueSession) {
            return ((QueueSession)session).createQueue(queueName);
        }
        return session.createQueue(queueName);
    }
}

