/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support.nativejdbc;

import com.bmc.thirdparty.org.springframework.jdbc.datasource.DataSourceUtils;
import com.bmc.thirdparty.org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class NativeJdbcExtractorAdapter
implements NativeJdbcExtractor {
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return false;
    }

    public Connection getNativeConnection(Connection con) throws SQLException {
        Connection metaCon;
        DatabaseMetaData metaData;
        if (con == null) {
            return null;
        }
        Connection targetCon = DataSourceUtils.getTargetConnection(con);
        Connection nativeCon = this.doGetNativeConnection(targetCon);
        if (nativeCon == targetCon && (metaData = targetCon.getMetaData()) != null && (metaCon = metaData.getConnection()) != targetCon) {
            nativeCon = this.doGetNativeConnection(metaCon);
        }
        return nativeCon;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        return con;
    }

    public Connection getNativeConnectionFromStatement(Statement stmt) throws SQLException {
        if (stmt == null) {
            return null;
        }
        return this.getNativeConnection(stmt.getConnection());
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        return ps;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        return cs;
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        return rs;
    }
}

