/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import com.bmc.thirdparty.org.springframework.jdbc.support.SQLExceptionTranslator;
import com.bmc.thirdparty.org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import javax.sql.DataSource;

public abstract class JdbcAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private SQLExceptionTranslator exceptionTranslator;
    private boolean lazyInit = true;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDatabaseProductName(String dbName) {
        this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dbName);
    }

    public void setExceptionTranslator(SQLExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            DataSource dataSource = this.getDataSource();
            this.exceptionTranslator = dataSource != null ? new SQLErrorCodeSQLExceptionTranslator(dataSource) : new SQLStateSQLExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void afterPropertiesSet() {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        if (!this.isLazyInit()) {
            this.getExceptionTranslator();
        }
    }
}

