/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration.beanutils;

import com.bmc.thirdparty.org.apache.commons.beanutils.DynaBean;
import com.bmc.thirdparty.org.apache.commons.beanutils.DynaClass;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationMap;
import com.bmc.thirdparty.org.apache.commons.configuration.ConversionException;
import com.bmc.thirdparty.org.apache.commons.configuration.beanutils.ConfigurationDynaClass;
import com.bmc.thirdparty.org.apache.commons.lang.BooleanUtils;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.util.Iterator;
import java.util.List;

public class ConfigurationDynaBean
extends ConfigurationMap
implements DynaBean {
    private static Log log = LogFactory.getLog(class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean == null ? (class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean = ConfigurationDynaBean.class$("com.bmc.thirdparty.org.apache.commons.configuration.beanutils.ConfigurationDynaBean")) : class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean);
    static /* synthetic */ Class class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean;

    public ConfigurationDynaBean(Configuration configuration) {
        super(configuration);
        if (log.isTraceEnabled()) {
            log.trace("ConfigurationDynaBean(" + configuration + ")");
        }
    }

    public void set(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace("set(" + name + "," + value + ")");
        }
        if (value == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (value instanceof List) {
            List list = (List)value;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.getConfiguration().addProperty(name, iterator.next());
            }
        } else if (value instanceof int[]) {
            int[] array = (int[])value;
            int i2 = 0;
            while (i2 < array.length) {
                this.getConfiguration().addProperty(name, new Integer(array[i2]));
                ++i2;
            }
        } else if (value instanceof boolean[]) {
            boolean[] array = (boolean[])value;
            int i3 = 0;
            while (i3 < array.length) {
                this.getConfiguration().addProperty(name, BooleanUtils.toBooleanObject(array[i3]));
                ++i3;
            }
        } else if (value instanceof char[]) {
            char[] array = (char[])value;
            int i4 = 0;
            while (i4 < array.length) {
                this.getConfiguration().addProperty(name, new Character(array[i4]));
                ++i4;
            }
        } else if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            int i5 = 0;
            while (i5 < array.length) {
                this.getConfiguration().addProperty(name, new Byte(array[i5]));
                ++i5;
            }
        } else if (value instanceof short[]) {
            short[] array = (short[])value;
            int i6 = 0;
            while (i6 < array.length) {
                this.getConfiguration().addProperty(name, new Short(array[i6]));
                ++i6;
            }
        } else if (value instanceof long[]) {
            long[] array = (long[])value;
            int i7 = 0;
            while (i7 < array.length) {
                this.getConfiguration().addProperty(name, new Long(array[i7]));
                ++i7;
            }
        } else if (value instanceof float[]) {
            float[] array = (float[])value;
            int i8 = 0;
            while (i8 < array.length) {
                this.getConfiguration().addProperty(name, new Float(array[i8]));
                ++i8;
            }
        } else if (value instanceof double[]) {
            double[] array = (double[])value;
            int i9 = 0;
            while (i9 < array.length) {
                this.getConfiguration().addProperty(name, new Double(array[i9]));
                ++i9;
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int i10 = 0;
            while (i10 < array.length) {
                this.getConfiguration().addProperty(name, array[i10]);
                ++i10;
            }
        } else {
            this.getConfiguration().setProperty(name, value);
        }
    }

    public Object get(String name) {
        Configuration subset;
        Object result;
        if (log.isTraceEnabled()) {
            log.trace("get(" + name + ")");
        }
        if ((result = this.getConfiguration().getProperty(name)) == null && !(subset = this.getConfiguration().subset(name)).isEmpty()) {
            result = new ConfigurationDynaBean(this.getConfiguration().subset(name));
        }
        if (log.isDebugEnabled()) {
            log.debug(name + "=[" + result + "]");
        }
        if (result == null) {
            throw new IllegalArgumentException("Property '" + name + "' does not exist.");
        }
        return result;
    }

    public boolean contains(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.containsKey(key);
    }

    public Object get(String name, int index) {
        try {
            List list = this.getConfiguration().getList(name);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Indexed property '" + name + "' does not exist.");
            }
            return list.get(index);
        }
        catch (ConversionException e2) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
    }

    public Object get(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.getProperty(key);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.getConfiguration());
    }

    public void remove(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        subset.setProperty(key, null);
    }

    public void set(String name, int index, Object value) {
        block6: {
            try {
                Object property = this.getConfiguration().getProperty(name);
                if (property == null) {
                    throw new IllegalArgumentException("Property '" + name + "' does not exist.");
                }
                if (property instanceof List) {
                    List list = (List)property;
                    list.set(index, value);
                    break block6;
                }
                if (property.getClass().isArray()) {
                    Object[] array = (Object[])property;
                    array[index] = value;
                    break block6;
                }
                if (index == 0) {
                    this.getConfiguration().setProperty(name, value);
                    break block6;
                }
                throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
            }
            catch (ConversionException e2) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
            }
        }
    }

    public void set(String name, String key, Object value) {
        this.getConfiguration().setProperty(name + "." + key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

