/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.view;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.bmc.thirdparty.org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import com.bmc.thirdparty.org.springframework.context.ConfigurableApplicationContext;
import com.bmc.thirdparty.org.springframework.core.Ordered;
import com.bmc.thirdparty.org.springframework.web.context.support.GenericWebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.servlet.View;
import com.bmc.thirdparty.org.springframework.web.servlet.view.AbstractCachingViewResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleViewResolver
extends AbstractCachingViewResolver
implements Ordered,
DisposableBean {
    public static final String DEFAULT_BASENAME = "views";
    private int order = Integer.MAX_VALUE;
    private String[] basenames = new String[]{"views"};
    private ClassLoader bundleClassLoader = Thread.currentThread().getContextClassLoader();
    private String defaultParentView;
    private final Map localeCache = new HashMap();
    private final Map bundleCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$View;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader;
    }

    public void setDefaultParentView(String defaultParentView) {
        this.defaultParentView = defaultParentView;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        BeanFactory factory = this.initFactory(locale);
        try {
            return (View)factory.getBean(viewName, class$org$springframework$web$servlet$View == null ? (class$org$springframework$web$servlet$View = ResourceBundleViewResolver.class$("com.bmc.thirdparty.org.springframework.web.servlet.View")) : class$org$springframework$web$servlet$View);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    protected synchronized BeanFactory initFactory(Locale locale) throws Exception {
        BeanFactory cachedFactory;
        BeanFactory cachedFactory2;
        if (this.isCache() && (cachedFactory2 = (BeanFactory)this.localeCache.get(locale)) != null) {
            return cachedFactory2;
        }
        LinkedList<ResourceBundle> bundles = new LinkedList<ResourceBundle>();
        for (int i2 = 0; i2 < this.basenames.length; ++i2) {
            ResourceBundle bundle = this.getBundle(this.basenames[i2], locale);
            bundles.add(bundle);
        }
        if (this.isCache() && (cachedFactory = (BeanFactory)this.bundleCache.get(bundles)) != null) {
            this.localeCache.put(locale, cachedFactory);
            return cachedFactory;
        }
        GenericWebApplicationContext factory = new GenericWebApplicationContext();
        factory.setParent(this.getApplicationContext());
        factory.setServletContext(this.getServletContext());
        PropertiesBeanDefinitionReader reader = new PropertiesBeanDefinitionReader(factory);
        reader.setDefaultParentBean(this.defaultParentView);
        for (int i3 = 0; i3 < bundles.size(); ++i3) {
            ResourceBundle bundle = (ResourceBundle)bundles.get(i3);
            reader.registerBeanDefinitions(bundle);
        }
        factory.refresh();
        if (this.isCache()) {
            this.localeCache.put(locale, factory);
            this.bundleCache.put(bundles, factory);
        }
        return factory;
    }

    protected ResourceBundle getBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
    }

    public void destroy() throws BeansException {
        Iterator it = this.bundleCache.values().iterator();
        while (it.hasNext()) {
            ConfigurableApplicationContext factory = (ConfigurableApplicationContext)it.next();
            factory.close();
        }
        this.localeCache.clear();
        this.bundleCache.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

