/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support.lob;

import com.bmc.thirdparty.org.springframework.jdbc.support.lob.LobCreator;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.transaction.Synchronization;

public class JtaLobCreatorSynchronization
implements Synchronization {
    private final LobCreator lobCreator;
    private boolean beforeCompletionCalled = false;

    public JtaLobCreatorSynchronization(LobCreator lobCreator) {
        Assert.notNull(lobCreator, "LobCreator must not be null");
        this.lobCreator = lobCreator;
    }

    public void beforeCompletion() {
        this.beforeCompletionCalled = true;
        this.lobCreator.close();
    }

    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.lobCreator.close();
        }
    }
}

