/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.propertyeditors;

import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;

public class StringArrayPropertyEditor
extends PropertyEditorSupport {
    public static final String DEFAULT_SEPARATOR = ",";
    private final String separator;

    public StringArrayPropertyEditor() {
        this.separator = DEFAULT_SEPARATOR;
    }

    public StringArrayPropertyEditor(String separator) {
        this.separator = separator;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String[] array = StringUtils.delimitedListToStringArray(text, this.separator);
        this.setValue(array);
    }

    public String getAsText() {
        Object[] array = (String[])this.getValue();
        return StringUtils.arrayToDelimitedString(array, this.separator);
    }
}

