/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.handler;

import com.bmc.thirdparty.org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserRoleAuthorizationInterceptor
extends HandlerInterceptorAdapter {
    private String[] authorizedRoles;

    public final void setAuthorizedRoles(String[] authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException, IOException {
        if (this.authorizedRoles != null) {
            for (int i2 = 0; i2 < this.authorizedRoles.length; ++i2) {
                if (!request.isUserInRole(this.authorizedRoles[i2])) continue;
                return true;
            }
        }
        this.handleNotAuthorized(request, response, handler);
        return false;
    }

    protected void handleNotAuthorized(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException, IOException {
        response.sendError(403);
    }
}

