/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.util.xml;

import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DomUtils {
    public static List getChildElementsByTagName(Element ele, String childEleName) {
        NodeList nl = ele.getChildNodes();
        ArrayList<Node> childEles = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node node = nl.item(i2);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, childEleName)) continue;
            childEles.add(node);
        }
        return childEles;
    }

    public static Element getChildElementByTagName(Element ele, String childEleName) {
        NodeList nl = ele.getChildNodes();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node node = nl.item(i2);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, childEleName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getChildElementValueByTagName(Element ele, String childEleName) {
        Element child = DomUtils.getChildElementByTagName(ele, childEleName);
        return child != null ? DomUtils.getTextValue(child) : null;
    }

    public static boolean nodeNameEquals(Node node, String desiredName) {
        Assert.notNull(node, "Node must not be null");
        Assert.notNull(desiredName, "Desired name must not be null");
        return desiredName.equals(node.getNodeName()) || desiredName.equals(node.getLocalName());
    }

    public static String getTextValue(Element valueEle) {
        StringBuffer value = new StringBuffer();
        NodeList nl = valueEle.getChildNodes();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            Node item = nl.item(i2);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }
}

