/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.quartz;

import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.scheduling.SchedulingTaskExecutor;
import com.bmc.thirdparty.org.springframework.util.Assert;
import org.quartz.SchedulerConfigException;
import org.quartz.simpl.SimpleThreadPool;

public class SimpleThreadPoolTaskExecutor
extends SimpleThreadPool
implements SchedulingTaskExecutor,
InitializingBean,
DisposableBean {
    private boolean waitForJobsToCompleteOnShutdown = false;

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void afterPropertiesSet() throws SchedulerConfigException {
        this.initialize();
    }

    public void execute(Runnable task) {
        Assert.notNull(task, "Runnable must not be null");
        this.runInThread(task);
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void destroy() {
        this.shutdown(this.waitForJobsToCompleteOnShutdown);
    }
}

