/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.object;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.InvalidDataAccessApiUsageException;
import com.bmc.thirdparty.org.springframework.jdbc.core.JdbcTemplate;
import com.bmc.thirdparty.org.springframework.jdbc.core.ParameterMapper;
import com.bmc.thirdparty.org.springframework.jdbc.core.SqlParameter;
import com.bmc.thirdparty.org.springframework.jdbc.object.SqlCall;
import java.util.Map;
import javax.sql.DataSource;

public abstract class StoredProcedure
extends SqlCall {
    protected StoredProcedure() {
    }

    protected StoredProcedure(DataSource ds, String name) {
        this.setDataSource(ds);
        this.setSql(name);
    }

    protected StoredProcedure(JdbcTemplate jdbcTemplate, String name) {
        this.setJdbcTemplate(jdbcTemplate);
        this.setSql(name);
    }

    protected boolean allowsUnusedParameters() {
        return true;
    }

    public void declareParameter(SqlParameter param) throws InvalidDataAccessApiUsageException {
        if (param.getName() == null) {
            throw new InvalidDataAccessApiUsageException("Parameters to stored procedures must have names as well as types");
        }
        super.declareParameter(param);
    }

    public Map execute(Map inParams) throws DataAccessException {
        this.validateParameters(inParams.values().toArray());
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParams), this.getDeclaredParameters());
    }

    public Map execute(ParameterMapper inParamMapper) throws DataAccessException {
        this.checkCompiled();
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParamMapper), this.getDeclaredParameters());
    }
}

