/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.test.TestUtils;
import org.apache.xml.security.test.resource.TestVectorResolver;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Canonicalizer20010315Test
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test = Canonicalizer20010315Test.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer20010315Test")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test).getName());
    private static String prefix = "data/org/apache/xml/security/c14n/";
    static /* synthetic */ Class class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test = Canonicalizer20010315Test.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer20010315Test")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test);
    }

    public Canonicalizer20010315Test(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test = Canonicalizer20010315Test.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer20010315Test")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315Test).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public static void test31withCommentsSubtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (commented)";
        String string2 = prefix + "in/31_input.xml";
        String string3 = prefix + "in/31_c14n-comments.xml";
        String string4 = prefix + "out/xpath_31_output-comments.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test31withCommentsSubset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (commented)";
        String string2 = prefix + "in/31_input.xml";
        String string3 = prefix + "in/31_c14n-comments.xml";
        String string4 = prefix + "out/xpath_31_output-comments.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test31subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (uncommented)";
        String string2 = prefix + "in/31_input.xml";
        String string3 = prefix + "in/31_c14n.xml";
        String string4 = prefix + "out/xpath_31_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test31subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.1: PIs, Comments, and Outside of Document Element. (uncommented)";
        String string2 = prefix + "in/31_input.xml";
        String string3 = prefix + "in/31_c14n.xml";
        String string4 = prefix + "out/xpath_31_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test32subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.2 Whitespace in Document Content. (uncommented)";
        String string2 = prefix + "in/32_input.xml";
        String string3 = prefix + "in/32_c14n.xml";
        String string4 = prefix + "out/xpath_32_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test32subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.2 Whitespace in Document Content. (uncommented)";
        String string2 = prefix + "in/32_input.xml";
        String string3 = prefix + "in/32_c14n.xml";
        String string4 = prefix + "out/xpath_32_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test33subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.3 Start and End Tags. (uncommented)";
        String string2 = prefix + "in/33_input.xml";
        String string3 = prefix + "in/33_c14n.xml";
        String string4 = prefix + "out/xpath_33_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test33subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.3 Start and End Tags. (uncommented)";
        String string2 = prefix + "in/33_input.xml";
        String string3 = prefix + "in/33_c14n.xml";
        String string4 = prefix + "out/xpath_33_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test34() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.4 Character Modifications and Character References. (uncommented)";
        String string2 = prefix + "in/34_input.xml";
        String string3 = prefix + "in/34_c14n.xml";
        String string4 = prefix + "out/xpath_34_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = false;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test34subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.4 Character Modifications and Character References. (uncommented, patched to run on validating Parsers)";
        String string2 = prefix + "in/34_input_validatingParser.xml";
        String string3 = prefix + "in/34_c14n_validatingParser.xml";
        String string4 = prefix + "out/xpath_34_output_validatingParser.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test34subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.4 Character Modifications and Character References. (uncommented, patched to run on validating Parsers)";
        String string2 = prefix + "in/34_input_validatingParser.xml";
        String string3 = prefix + "in/34_c14n_validatingParser.xml";
        String string4 = prefix + "out/xpath_34_output_validatingParser.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test35subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.5 Entity References. (uncommented)";
        String string2 = prefix + "in/35_input.xml";
        String string3 = prefix + "in/35_c14n.xml";
        String string4 = prefix + "out/xpath_35_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test35subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.5 Entity References. (uncommented)";
        String string2 = prefix + "in/35_input.xml";
        String string3 = prefix + "in/35_c14n.xml";
        String string4 = prefix + "out/xpath_35_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test36subtree() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.6 UTF-8 Encoding. (uncommented)";
        String string2 = prefix + "in/36_input.xml";
        String string3 = prefix + "in/36_c14n.xml";
        String string4 = prefix + "out/xpath_36_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Object var6_6 = null;
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, var6_6));
    }

    public static void test36subset() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.6 UTF-8 Encoding. (uncommented)";
        String string2 = prefix + "in/36_input.xml";
        String string3 = prefix + "in/36_c14n.xml";
        String string4 = prefix + "out/xpath_36_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        String string6 = "(.//. | .//@* | .//namespace::*)";
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, string6));
    }

    public static void test37() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "3.7 Document Subsets. (uncommented)";
        String string2 = prefix + "in/37_input.xml";
        String string3 = prefix + "in/37_c14n.xml";
        String string4 = prefix + "out/xpath_37_output.xml";
        String string5 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        boolean bl = true;
        Element element = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        element = XMLUtils.createElementInSignatureSpace((Document)document, (String)"XPath");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ietf", "http://www.ietf.org");
        String string6 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        element.appendChild(document.createTextNode(string6));
        Canonicalizer20010315Test.assertTrue((String)string, (boolean)Canonicalizer20010315Test.c14nAndCompare(string2, string3, string4, string5, bl, element));
    }

    public static void test37byNodeList() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = prefix + "in/37_input.xml";
        String string2 = prefix + "in/37_c14n.xml";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        TestVectorResolver testVectorResolver = new TestVectorResolver();
        documentBuilder.setEntityResolver(testVectorResolver);
        Document document = documentBuilder.parse(testVectorResolver.resolveEntity(null, string));
        Element element = TestUtils.createDSctx(document, "ietf", "http://www.ietf.org");
        String string3 = "(//. | //@* | //namespace::*)[ self::ietf:e1 or (parent::ietf:e1 and not(self::text() or self::e2)) or count(id(\"E3\")|ancestor-or-self::node()) = count(ancestor-or-self::node()) ]";
        CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
        NodeList nodeList = cachedXPathAPI.selectNodeList((Node)document, string3, (Node)element);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] byArray = canonicalizer.canonicalizeXPathNodeSet(nodeList);
        InputStream inputStream = testVectorResolver.resolveEntity(null, string2).getByteStream();
        byte[] byArray2 = JavaUtils.getBytesFromStream((InputStream)inputStream);
        Canonicalizer20010315Test.assertEquals((String)new String(byArray2), (String)new String(byArray));
    }

    public static void testRelativeNSbehaviour() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<absolute:correct      xmlns:absolute='http://www.absolute.org/#likeVodka'><relative:incorrect    xmlns:relative='../cheating#away'></relative:incorrect></absolute:correct>\n";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        boolean bl = false;
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizer.canonicalizeSubtree((Node)document);
        }
        catch (CanonicalizationException canonicalizationException) {
            log.debug((Object)("We catched the C14nEx, that's good: " + canonicalizationException.getMessage()));
            bl = true;
        }
        Canonicalizer20010315Test.assertTrue((String)"We did not catch the relative namespace", (boolean)bl);
    }

    public static void testTranslationFromUTF16toUTF8() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<UTF16>The german &amp;auml (which is Unicode &amp;#xE4;):  &quot;&#xE4;&quot;</UTF16>";
        byte[] byArray = Canonicalizer20010315Test.convertToUTF16(string.getBytes());
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] byArray2 = canonicalizer.canonicalize(byArray);
        TestVectorResolver testVectorResolver = new TestVectorResolver();
        InputStream inputStream = testVectorResolver.resolveEntity(null, prefix + "/in/testTranslationFromUTF16toUTF8.xml").getByteStream();
        byte[] byArray3 = JavaUtils.getBytesFromStream((InputStream)inputStream);
        boolean bl = MessageDigest.isEqual(byArray3, byArray2);
        Canonicalizer20010315Test.assertTrue((String)"Parser does not translate to UCS character domain", (boolean)bl);
    }

    public static void testXMLAttributes1() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<included    xml:lang='de'><notIncluded xml:lang='de'><notIncluded xml:lang='uk'><included                 ></included></notIncluded></notIncluded></included>";
        String string2 = "<included xml:lang=\"de\"><included xml:lang=\"uk\"></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)Canonicalizer20010315Test.doTestXMLAttributes(string, string2));
    }

    public static void testXMLAttributes2() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<included    xml:lang='uk'><notIncluded xml:lang='de'><notIncluded xml:lang='uk'><included                 ></included></notIncluded></notIncluded></included>";
        String string2 = "<included xml:lang=\"uk\"><included xml:lang=\"uk\"></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)Canonicalizer20010315Test.doTestXMLAttributes(string, string2));
    }

    public static void testXMLAttributes3() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<included    xml:lang='de'><notIncluded xml:lang='de'><notIncluded xml:lang='uk'><included    xml:lang='de'></included></notIncluded></notIncluded></included>";
        String string2 = "<included xml:lang=\"de\"><included xml:lang=\"de\"></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)Canonicalizer20010315Test.doTestXMLAttributes(string, string2));
    }

    public static void _testXMLAttributes4() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<included    xml:lang='de'><included    xml:lang='de'><notIncluded xml:lang='uk'><included                 ></included></notIncluded></included></included>";
        String string2 = "<included xml:lang=\"de\"><included><included xml:lang=\"uk\"></included></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)Canonicalizer20010315Test.doTestXMLAttributes(string, string2));
    }

    public static void _testXMLAttributes5() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<included                         xml:lang='de'><included                         xml:lang='de'><notIncluded xml:space='preserve' xml:lang='uk'><included                 ></included></notIncluded></included></included>";
        String string2 = "<included xml:lang=\"de\"><included><included xml:lang=\"uk\" xml:space=\"preserve\"></included></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)Canonicalizer20010315Test.doTestXMLAttributes(string, string2));
    }

    public static void _testXMLAttributes6() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        String string = "<included   xml:space='preserve'  xml:lang='de'><included                         xml:lang='de'><notIncluded                      xml:lang='uk'><included></included></notIncluded></included></included>";
        String string2 = "<included xml:lang=\"de\" xml:space=\"preserve\"><included><included xml:lang=\"uk\" xml:space=\"preserve\"></included></included></included>";
        Canonicalizer20010315Test.assertTrue((boolean)Canonicalizer20010315Test.doTestXMLAttributes(string, string2));
    }

    private static boolean doTestXMLAttributes(String string, String string2) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
        NodeList nodeList = cachedXPathAPI.selectNodeList((Node)document, "(//*[local-name()='included'] | //@*[parent::node()[local-name()='included']])");
        byte[] byArray = canonicalizer.canonicalizeXPathNodeSet(nodeList);
        byte[] byArray2 = string2.getBytes();
        Canonicalizer20010315Test.assertEquals((String)string2, (String)new String(byArray));
        return MessageDigest.isEqual(byArray2, byArray);
    }

    private static boolean c14nAndCompare(String string, String string2, String string3, String string4, boolean bl, Object object) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException {
        Object object2;
        Object object3;
        Object object4;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        Document document = documentBuilder.parse(string);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)string4);
        byte[] byArray = null;
        if (object == null) {
            byArray = canonicalizer.canonicalizeSubtree((Node)document);
        } else {
            object4 = new CachedXPathAPI();
            NodeList nodeList = null;
            if (object instanceof String) {
                nodeList = object4.selectNodeList((Node)document, (String)object);
            } else {
                object3 = (Element)object;
                object2 = ((Text)object3.getFirstChild()).getData();
                nodeList = object4.selectNodeList((Node)document, (String)object2, (Node)object3);
            }
            byArray = canonicalizer.canonicalizeXPathNodeSet(nodeList);
        }
        object4 = JavaUtils.getBytesFromFile((String)string2);
        boolean bl2 = MessageDigest.isEqual((byte[])object4, byArray);
        if (!bl2) {
            object3 = new File(string3);
            if (!((File)object3).exists()) {
                object2 = new File(((File)object3).getParent());
                ((File)object2).mkdirs();
                ((File)object3).createNewFile();
            }
            object2 = new FileOutputStream((File)object3);
            ((FileOutputStream)object2).write(byArray);
            log.debug((Object)("Wrote errornous result to file " + ((File)object3).toURL().toString()));
            Canonicalizer20010315Test.assertEquals((String)new String((byte[])object4), (String)new String(byArray));
        }
        return bl2;
    }

    public static byte[] convertToUTF16(byte[] byArray) throws ParserConfigurationException, IOException, SAXException, TransformerConfigurationException, TransformerException {
        String string = "UTF-16";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", string);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DOMSource dOMSource = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toByteArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("basedir");
        if (string != null && !"".equals(string)) {
            prefix = string + "/" + prefix;
        }
        Init.init();
    }
}

