/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.utils.Messages;

public abstract class AbstractXMLEncoder
implements XMLEncoder {
    protected static final String AMP = "&amp;";
    protected static final String QUOTE = "&quot;";
    protected static final String LESS = "&lt;";
    protected static final String GREATER = "&gt;";
    protected static final String LF = "\n";
    protected static final String CR = "\r";
    protected static final String TAB = "\t";

    public abstract String getEncoding();

    public String encode(String xmlString) {
        if (xmlString == null) {
            return "";
        }
        char[] characters = xmlString.toCharArray();
        StringBuffer out = null;
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '&': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(AMP);
                    break;
                }
                case '\"': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(QUOTE);
                    break;
                }
                case '<': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(LESS);
                    break;
                }
                case '>': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(GREATER);
                    break;
                }
                case '\n': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(LF);
                    break;
                }
                case '\r': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(CR);
                    break;
                }
                case '\t': {
                    if (out == null) {
                        out = this.getInitialByteArray(xmlString, i);
                    }
                    out.append(TAB);
                    break;
                }
                default: {
                    if (character < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(character), xmlString.substring(0, i)));
                    }
                    if (out == null) break;
                    out.append(character);
                }
            }
            ++i;
        }
        if (out == null) {
            return xmlString;
        }
        return out.toString();
    }

    protected StringBuffer getInitialByteArray(String aXmlString, int pos) {
        return new StringBuffer(aXmlString.substring(0, pos));
    }
}

